/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.modularmultiblock.ModularMultiblockGuiLine;

public final class ModularMultiblockGuiClient
implements GuiComponentClient {
    private int height;
    private List<ModularMultiblockGuiLine> text;

    public ModularMultiblockGuiClient(FriendlyByteBuf buf) {
        this.readCurrentData(buf);
    }

    public void readCurrentData(FriendlyByteBuf buf) {
        this.height = buf.readInt();
        this.text = (List)buf.readCollection(Lists::newArrayListWithCapacity, ModularMultiblockGuiLine::read);
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public final class Renderer
    implements ClientComponentRenderer {
        private static final ResourceLocation TEXTURE = MI.id((String)"textures/gui/container/multiblock_info.png");

        public void renderBackground(GuiGraphics graphics, int x, int y) {
            Minecraft minecraftClient = Minecraft.getInstance();
            Font font = minecraftClient.font;
            graphics.blit(TEXTURE, x + 4, y + 16, 0.0f, 0.0f, 166, 2, 166, 80);
            graphics.blit(TEXTURE, x + 4, y + 16 + 2, 0.0f, 2.0f, 166, ModularMultiblockGuiClient.this.height - 4, 166, 80);
            graphics.blit(TEXTURE, x + 4, y + 16 + ModularMultiblockGuiClient.this.height - 2, 0.0f, 78.0f, 166, 2, 166, 80);
            int deltaY = 23;
            for (ModularMultiblockGuiLine line : ModularMultiblockGuiClient.this.text) {
                graphics.drawString(font, line.text(), x + 9, y + deltaY, line.color(), false);
                deltaY += 11;
            }
        }
    }
}

