/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.recipeefficiency;

import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.TesseractMod;
import net.swedz.tesseract.neoforge.compat.mi.component.craft.ModularCrafterAccess;

public final class ModularRecipeEfficiencyBar {
    public static final ResourceLocation ID = TesseractMod.id("modular_recipe_efficiency");

    public record Parameters(int renderX, int renderY) {
    }

    private record Data(boolean hasActiveRecipe, int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu, long maxRecipeEu) {
        private Data(int efficiencyTicks, int maxEfficiencyTicks, long currentRecipeEu, long baseRecipeEu, long maxRecipeEu) {
            this(true, efficiencyTicks, maxEfficiencyTicks, currentRecipeEu, baseRecipeEu, maxRecipeEu);
        }

        private Data() {
            this(false, 0, 0, 0L, 0L, 0L);
        }
    }

    public static final class Server
    implements GuiComponent.Server<Data> {
        private final Parameters params;
        private final ModularCrafterAccess crafter;

        public Server(Parameters params, ModularCrafterAccess crafter) {
            this.params = params;
            this.crafter = crafter;
        }

        public Data copyData() {
            if (this.crafter.hasActiveRecipe()) {
                return new Data(this.crafter.getEfficiencyTicks(), this.crafter.getMaxEfficiencyTicks(), this.crafter.getCurrentRecipeEu(), this.crafter.getBaseRecipeEu(), this.crafter.getBehavior().getMaxRecipeEu());
            }
            return new Data();
        }

        public boolean needsSync(Data cachedData) {
            if (!this.crafter.hasActiveRecipe()) {
                return cachedData.hasActiveRecipe;
            }
            return this.crafter.getEfficiencyTicks() != cachedData.efficiencyTicks || this.crafter.getMaxEfficiencyTicks() != cachedData.maxEfficiencyTicks || this.crafter.getCurrentRecipeEu() != cachedData.currentRecipeEu || this.crafter.getBaseRecipeEu() != cachedData.baseRecipeEu || this.crafter.getBehavior().getMaxRecipeEu() != cachedData.maxRecipeEu;
        }

        public void writeInitialData(FriendlyByteBuf buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(FriendlyByteBuf buf) {
            if (this.crafter.hasActiveRecipe()) {
                buf.writeBoolean(true);
                buf.writeInt(this.crafter.getEfficiencyTicks());
                buf.writeInt(this.crafter.getMaxEfficiencyTicks());
                buf.writeLong(this.crafter.getCurrentRecipeEu());
                buf.writeLong(this.crafter.getBaseRecipeEu());
            } else {
                buf.writeBoolean(false);
            }
            buf.writeLong(this.crafter.getBehavior().getMaxRecipeEu());
        }

        public ResourceLocation getId() {
            return GuiComponents.RECIPE_EFFICIENCY_BAR;
        }
    }
}

