/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.recipeefficiency;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.RenderHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.recipeefficiency.ModularRecipeEfficiencyBar;

public final class ModularRecipeEfficiencyBarClient
implements GuiComponentClient {
    final ModularRecipeEfficiencyBar.Parameters params;
    boolean hasActiveRecipe;
    int efficiencyTicks;
    int maxEfficiencyTicks;
    long currentRecipeEu;
    long baseRecipeEu;
    long maxRecipeEu;
    private static final ResourceLocation TEXTURE = new MIIdentifier("textures/gui/efficiency_bar.png");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 2;

    public ModularRecipeEfficiencyBarClient(FriendlyByteBuf buf) {
        this.params = new ModularRecipeEfficiencyBar.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    public void readCurrentData(FriendlyByteBuf buf) {
        this.hasActiveRecipe = buf.readBoolean();
        if (this.hasActiveRecipe) {
            this.efficiencyTicks = buf.readInt();
            this.maxEfficiencyTicks = buf.readInt();
            this.currentRecipeEu = buf.readLong();
            this.baseRecipeEu = buf.readLong();
        }
        this.maxRecipeEu = buf.readLong();
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return (guiGraphics, leftPos, topPos) -> {};
    }

    public class Renderer
    implements ClientComponentRenderer {
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(TEXTURE, x + ModularRecipeEfficiencyBarClient.this.params.renderX() - 1, y + ModularRecipeEfficiencyBarClient.this.params.renderY() - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            if (ModularRecipeEfficiencyBarClient.this.hasActiveRecipe) {
                int barPixels = (int)((float)ModularRecipeEfficiencyBarClient.this.efficiencyTicks / (float)ModularRecipeEfficiencyBarClient.this.maxEfficiencyTicks * 100.0f);
                guiGraphics.blit(TEXTURE, x + ModularRecipeEfficiencyBarClient.this.params.renderX(), y + ModularRecipeEfficiencyBarClient.this.params.renderY(), 0.0f, 0.0f, barPixels, 2, 102, 6);
            }
        }

        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle((int)ModularRecipeEfficiencyBarClient.this.params.renderX(), (int)ModularRecipeEfficiencyBarClient.this.params.renderY(), (int)100, (int)2, (double)(cursorX - x), (double)(cursorY - y))) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (ModularRecipeEfficiencyBarClient.this.hasActiveRecipe) {
                    DecimalFormat factorFormat = new DecimalFormat("#.#");
                    tooltip.add(MIText.EfficiencyTicks.text(new Object[]{ModularRecipeEfficiencyBarClient.this.efficiencyTicks, ModularRecipeEfficiencyBarClient.this.maxEfficiencyTicks}));
                    tooltip.add(MIText.EfficiencyFactor.text(new Object[]{factorFormat.format((double)ModularRecipeEfficiencyBarClient.this.currentRecipeEu / (double)ModularRecipeEfficiencyBarClient.this.baseRecipeEu)}));
                    tooltip.add(MIText.EfficiencyEu.text(new Object[]{ModularRecipeEfficiencyBarClient.this.currentRecipeEu}));
                } else {
                    tooltip.add(MIText.EfficiencyDefaultMessage.text());
                }
                tooltip.add(MIText.EfficiencyMaxOverclock.text(new Object[]{ModularRecipeEfficiencyBarClient.this.maxRecipeEu}));
                guiGraphics.renderTooltip(font, tooltip, Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

