/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.tesseract.neoforge.TesseractText;
import net.swedz.tesseract.neoforge.compat.mi.builtinhook.TesseractMITooltips;
import net.swedz.tesseract.neoforge.compat.mi.helper.ModularLubricantHelper;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractMultipliedCraftingMultiblockBlockEntity;

public abstract class AbstractElectricMultipliedCraftingMultiblockBlockEntity
extends AbstractMultipliedCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private final MachineTier machineTier;
    private final UpgradeComponent upgrades;
    private final RedstoneControlComponent redstoneControl;
    private final List<EnergyComponent> energyInputs = Lists.newArrayList();

    public AbstractElectricMultipliedCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate[] shapeTemplates, MachineTier machineTier) {
        super(bep, name, shapeTemplates);
        this.machineTier = machineTier;
        this.upgrades = new UpgradeComponent();
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(new IComponent[]{this.upgrades, this.redstoneControl});
        this.registerGuiComponent(new GuiComponent.Server[]{new SlotPanel.Server((MachineBlockEntity)this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades)});
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    public void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        if (!result.consumesAction()) {
            result = ModularLubricantHelper.onUse(this.crafter, player, hand);
        }
        if (!result.consumesAction()) {
            result = (InteractionResult)this.mapComponentOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse((MachineBlockEntity)this, player, hand), result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, simulation);
        }
        return total;
    }

    @Override
    public long getBaseRecipeEu() {
        return this.machineTier.getBaseEu();
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return (long)this.machineTier.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    public List<Component> getTooltips() {
        return List.of(MITooltips.DEFAULT_PARSER.parse((Object)TesseractText.MI_MACHINE_BATCHER_RECIPE.text(TesseractMITooltips.MACHINE_RECIPE_TYPE_PARSER.parse(true, this.getRecipeType()))), MITooltips.DEFAULT_PARSER.parse((Object)TesseractText.MI_MACHINE_BATCHER_SIZE_AND_COST.text(MITooltips.DEFAULT_PARSER.parse((Object)this.getMaxMultiplier()), TesseractMITooltips.EU_COST_TRANSFORMER_PARSER.parse((Object)this.getEuCostTransformer()))));
    }
}

