/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.OverclockComponent;
import aztech.modern_industrialization.machines.helper.SteamHelper;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.tesseract.neoforge.TesseractText;
import net.swedz.tesseract.neoforge.compat.mi.builtinhook.TesseractMITooltips;
import net.swedz.tesseract.neoforge.compat.mi.machine.blockentity.multiblock.multiplied.AbstractMultipliedCraftingMultiblockBlockEntity;

public abstract class AbstractSteamMultipliedCraftingMultiblockBlockEntity
extends AbstractMultipliedCraftingMultiblockBlockEntity {
    private final OverclockComponent overclock;
    private boolean steel;

    public AbstractSteamMultipliedCraftingMultiblockBlockEntity(BEP bep, String name, ShapeTemplate[] shapeTemplates, List<OverclockComponent.Catalyst> overclockCatalysts) {
        super(bep, name, shapeTemplates);
        this.overclock = new OverclockComponent(overclockCatalysts);
        this.registerComponents(new IComponent[]{this.overclock});
    }

    @Override
    public void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.steel = false;
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            if (!hatch.upgradesToSteel()) continue;
            this.steel = true;
            break;
        }
    }

    protected InteractionResult onUse(Player player, InteractionHand hand, Direction face) {
        InteractionResult result = super.onUse(player, hand, face);
        return !result.consumesAction() ? this.overclock.onUse((MachineBlockEntity)this, player, hand) : result;
    }

    @Override
    public long consumeEu(long max, Simulation simulation) {
        return SteamHelper.consumeSteamEu((List)this.inventory.getFluidInputs(), (long)max, (Simulation)simulation);
    }

    @Override
    public long getBaseRecipeEu() {
        return this.overclock.getRecipeEu(this.steel ? 4 : 2);
    }

    @Override
    public long getBaseMaxRecipeEu() {
        return this.getBaseRecipeEu();
    }

    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.addAll(this.overclock.getTooltips());
        tooltips.add(MITooltips.DEFAULT_PARSER.parse((Object)TesseractText.MI_MACHINE_BATCHER_RECIPE.text(TesseractMITooltips.MACHINE_RECIPE_TYPE_PARSER.parse(false, this.getRecipeType()))));
        tooltips.add(MITooltips.DEFAULT_PARSER.parse((Object)TesseractText.MI_MACHINE_BATCHER_SIZE_AND_COST.text(MITooltips.DEFAULT_PARSER.parse((Object)this.getMaxMultiplier()), TesseractMITooltips.EU_COST_TRANSFORMER_PARSER.parse((Object)this.getEuCostTransformer()))));
        return tooltips;
    }
}

