/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.datagen.mi.client;

import aztech.modern_industrialization.resource.FastPathPackResources;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import aztech.modern_industrialization.textures.coloramp.IColoramp;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.tesseract.neoforge.TesseractMod;
import net.swedz.tesseract.neoforge.registry.MIFluidProperties;
import net.swedz.tesseract.neoforge.registry.holder.FluidHolder;
import net.swedz.tesseract.neoforge.registry.holder.MIFluidHolder;

public final class TexturesMIHookDatagenProvider
implements DataProvider {
    private final PackOutput output;
    private final ExistingFileHelper existingFileHelper;
    private final String actualModId;
    private final Collection<FluidHolder> fluidHolders;

    public TexturesMIHookDatagenProvider(GatherDataEvent event, String actualModId, Collection<FluidHolder> fluidHolders) {
        this.output = event.getGenerator().getPackOutput();
        this.existingFileHelper = event.getExistingFileHelper();
        this.actualModId = actualModId;
        this.fluidHolders = fluidHolders;
    }

    private CompletableFuture<?> offerTextures(BiConsumer<NativeImage, String> textureWriter, BiConsumer<JsonElement, String> mcMetaWriter, ResourceProvider manager, ExistingFileHelper fileHelper) {
        TextureManager mtm = new TextureManager(manager, textureWriter, mcMetaWriter);
        ArrayList futures = new ArrayList();
        Consumer<IORunnable> defer = r -> futures.add(CompletableFuture.runAsync(r::safeRun, Util.backgroundExecutor()));
        for (FluidHolder holder : this.fluidHolders) {
            if (!(holder instanceof MIFluidHolder)) continue;
            MIFluidHolder fluid = (MIFluidHolder)holder;
            defer.accept(() -> this.registerFluidTextures(mtm, fluid));
        }
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenComposeAsync(v -> mtm.doEndWork(), (Executor)Util.backgroundExecutor())).thenRun(() -> mtm.markTexturesAsGenerated(fileHelper))).thenRun(() -> TesseractMod.LOGGER.info("\"I used the png to destroy the png.\": 2 Electric Boogaloo"));
    }

    private void registerFluidTextures(TextureManager tm, MIFluidHolder fluid) {
        MIFluidProperties properties = fluid.properties();
        String path = "modern_industrialization:textures/fluid/";
        String bucket = path + "bucket.png";
        String bucket_content = path + "bucket_content.png";
        Coloramp fluidColoramp = new Coloramp(properties.color());
        try {
            NativeImage bucket_image = tm.getAssetAsTexture(bucket);
            NativeImage bucket_content_image = tm.getAssetAsTexture(bucket_content);
            TextureHelper.colorize((NativeImage)bucket_content_image, (IColoramp)fluidColoramp);
            NativeImage oldBucketImage = bucket_image;
            bucket_image = TextureHelper.blend((NativeImage)oldBucketImage, (NativeImage)bucket_content_image);
            oldBucketImage.close();
            if (properties.isGas()) {
                TextureHelper.flip((NativeImage)bucket_image);
            }
            tm.addTexture(String.format("%s:textures/item/%s_bucket.png", this.actualModId, fluid.identifier().id()), bucket_image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String pathFluid = path + String.format("template/%s.png", properties.texture().path);
        try {
            NativeImage fluidAnim = tm.getAssetAsTexture(pathFluid);
            TextureHelper.colorize((NativeImage)fluidAnim, (IColoramp)fluidColoramp);
            TextureHelper.setAlpha((NativeImage)fluidAnim, (int)properties.opacity());
            tm.addTexture(String.format("%s:textures/fluid/%s_still.png", this.actualModId, fluid.identifier().id()), fluidAnim, true);
            tm.addMcMeta(String.format("%s:textures/fluid/%s_still.png.mcmeta", this.actualModId, fluid.identifier().id()), properties.texture().mcMetaInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList packs = Lists.newArrayList();
        packs.add(new VanillaPackResourcesBuilder().exposeNamespace(new String[]{"minecraft"}).pushJarResources().build());
        Path nonGeneratedResources = this.output.getOutputFolder().resolve("../../main/resources");
        packs.add(new FastPathPackResources("nonGen", nonGeneratedResources, true));
        packs.add(new FilePackResources("mi", new FilePackResources.SharedZipFileAccess(ModList.get().getModFileById("modern_industrialization").getFile().getFilePath().toFile()), true, ""));
        ArrayList jsonSaveFutures = Lists.newArrayList();
        MultiPackResourceManager fallbackProvider = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, (List)packs);
        return ((CompletableFuture)this.generateTextures(cache, (ResourceProvider)fallbackProvider, jsonSaveFutures::add).whenComplete((result, throwable) -> fallbackProvider.close())).thenRunAsync(() -> CompletableFuture.allOf((CompletableFuture[])jsonSaveFutures.toArray(CompletableFuture[]::new)), Util.backgroundExecutor());
    }

    private CompletableFuture<?> generateTextures(CachedOutput cache, ResourceProvider fallbackResourceProvider, Consumer<CompletableFuture<?>> futureList) {
        Path generatedResources = this.output.getOutputFolder();
        List<FastPathPackResources> generatedPack = List.of(new FastPathPackResources("gen", generatedResources, true));
        MultiPackResourceManager outputPack = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, generatedPack);
        return this.offerTextures((image, textureId) -> this.writeTexture(cache, (NativeImage)image, (String)textureId), (json, path) -> futureList.accept(this.customJsonSave(cache, (JsonElement)json, (String)path)), resourceLocation -> {
            Optional generated = outputPack.getResource(resourceLocation);
            if (generated.isPresent()) {
                return generated;
            }
            return fallbackResourceProvider.getResource(resourceLocation);
        }, this.existingFileHelper).whenComplete((result, throwable) -> outputPack.close());
    }

    private void writeTexture(CachedOutput cache, NativeImage image, String textureId) {
        try {
            Path path = this.output.getOutputFolder().resolve("assets").resolve(textureId.replace(':', '/'));
            cache.writeIfNeeded(path, image.asByteArray(), Hashing.sha1().hashBytes(image.asByteArray()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write texture " + textureId, ex);
        }
    }

    private CompletableFuture<?> customJsonSave(CachedOutput cache, JsonElement jsonElement, String path) {
        Path pathFormatted = this.output.getOutputFolder().resolve("assets").resolve(path.replace(':', '/'));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonElement, (Path)pathFormatted);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    @FunctionalInterface
    private static interface IORunnable {
        public void run() throws IOException;

        default public void safeRun() {
            try {
                this.run();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

