/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.registry.holder;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.tesseract.neoforge.api.FluidLike;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonCapabilities;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.BlockHolder;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;
import net.swedz.tesseract.neoforge.registry.registerable.SimpleRegisterableWrapper;

public class FluidHolder<F extends Fluid, FT extends FluidType, FB extends Block, FBI extends BucketItem>
extends RegisteredObjectHolder<Fluid, F, FluidHolder<F, FT, FB, FBI>>
implements FluidLike {
    private final SimpleRegisterableWrapper<Fluid, F> registerableFluid;
    private final SimpleRegisterableWrapper<FluidType, FT> registerableFluidType;
    private final BlockHolder<FB> blockHolder;
    private final ItemHolder<FBI> bucketItemHolder;

    public FluidHolder(ResourceLocation location, String englishName, DeferredRegister<Fluid> registerFluids, Function<FluidHolder<F, FT, FB, FBI>, F> creatorFluid, DeferredRegister<FluidType> registerFluidTypes, Function<FluidHolder<F, FT, FB, FBI>, FT> creatorFluidType, DeferredRegister.Blocks registerBlocks, BiFunction<FluidHolder<F, FT, FB, FBI>, BlockBehaviour.Properties, FB> creatorFluidBlock, DeferredRegister.Items registerItems, BiFunction<FluidHolder<F, FT, FB, FBI>, Item.Properties, FBI> creatorBucketItem, SortOrder bucketSortOrder) {
        super(location, englishName);
        this.registerableFluid = new SimpleRegisterableWrapper<Fluid, Fluid>(registerFluids, () -> (Fluid)creatorFluid.apply(this));
        this.registerableFluidType = new SimpleRegisterableWrapper<FluidType, FluidType>(registerFluidTypes, () -> (FluidType)creatorFluidType.apply(this));
        this.blockHolder = new BlockHolder<Block>(location, englishName, registerBlocks, p -> (Block)creatorFluidBlock.apply(this, (BlockBehaviour.Properties)p));
        this.bucketItemHolder = (ItemHolder)new ItemHolder<BucketItem>(new ResourceLocation(location.getNamespace(), location.getPath() + "_bucket"), englishName + " Bucket", registerItems, p -> (BucketItem)creatorBucketItem.apply(this, (Item.Properties)p)).sorted(bucketSortOrder).withModel(CommonModelBuilders::generated).withCapabilities(CommonCapabilities::bucketItem);
    }

    public SimpleRegisterableWrapper<Fluid, F> registerableFluid() {
        return this.registerableFluid;
    }

    public SimpleRegisterableWrapper<FluidType, FT> registerableFluidType() {
        return this.registerableFluidType;
    }

    public BlockHolder<FB> block() {
        return this.blockHolder;
    }

    public ItemHolder<FBI> bucketItem() {
        return this.bucketItemHolder;
    }

    @Override
    public FluidHolder<F, FT, FB, FBI> register() {
        this.guaranteeUnlocked();
        this.registerableFluid.registerSimple(this.identifier, DeferredRegister::register);
        this.registerableFluidType.registerSimple(this.identifier, DeferredRegister::register);
        this.blockHolder.register();
        this.bucketItemHolder.register();
        this.lock();
        return this;
    }

    @Override
    public F get() {
        return (F)((Fluid)this.registerableFluid.getOrThrow());
    }

    @Override
    public Fluid asFluid() {
        return this.get();
    }
}

