/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticle;

class BarrelBlockClientExtensions
implements IClientBlockExtensions {
    private final BarrelBlock barrelBlock;
    private final Random random = new Random();

    public BarrelBlockClientExtensions(BarrelBlock barrelBlock) {
        this.barrelBlock = barrelBlock;
    }

    public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
        ClientLevel clientLevel;
        block12: {
            block11: {
                if (state.getBlock() != this.barrelBlock || !(level instanceof ClientLevel)) break block11;
                clientLevel = (ClientLevel)level;
                if (target instanceof BlockHitResult) break block12;
            }
            return false;
        }
        BlockHitResult blockHitResult = (BlockHitResult)target;
        if (this.barrelBlock instanceof LimitedBarrelBlock && this.barrelBlock.getFacing(state) == blockHitResult.getDirection()) {
            return true;
        }
        Direction sideHit = blockHitResult.getDirection();
        BlockPos pos = blockHitResult.getBlockPos();
        if (state.getRenderShape() != RenderShape.INVISIBLE) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            AABB aabb = state.getShape((BlockGetter)level, pos).bounds();
            double d0 = (double)i + this.random.nextDouble() * (aabb.maxX - aabb.minX - (double)0.2f) + (double)0.1f + aabb.minX;
            double d1 = (double)j + this.random.nextDouble() * (aabb.maxY - aabb.minY - (double)0.2f) + (double)0.1f + aabb.minY;
            double d2 = (double)k + this.random.nextDouble() * (aabb.maxZ - aabb.minZ - (double)0.2f) + (double)0.1f + aabb.minZ;
            if (sideHit == Direction.DOWN) {
                d1 = (double)j + aabb.minY - (double)0.1f;
            }
            if (sideHit == Direction.UP) {
                d1 = (double)j + aabb.maxY + (double)0.1f;
            }
            if (sideHit == Direction.NORTH) {
                d2 = (double)k + aabb.minZ - (double)0.1f;
            }
            if (sideHit == Direction.SOUTH) {
                d2 = (double)k + aabb.maxZ + (double)0.1f;
            }
            if (sideHit == Direction.WEST) {
                d0 = (double)i + aabb.minX - (double)0.1f;
            }
            if (sideHit == Direction.EAST) {
                d0 = (double)i + aabb.maxX + (double)0.1f;
            }
            manager.add(new CustomTintTerrainParticle(clientLevel, d0, d1, d2, 0.0, 0.0, 0.0, state, pos).updateSprite(state, pos).setPower(0.2f).scale(0.6f));
        }
        return true;
    }

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
        if (state.getBlock() != this.barrelBlock || !(level instanceof ClientLevel)) {
            return false;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        VoxelShape voxelshape = state.getShape((BlockGetter)level, pos);
        voxelshape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double d1 = Math.min(1.0, maxX - minX);
            double d2 = Math.min(1.0, maxY - minY);
            double d3 = Math.min(1.0, maxZ - minZ);
            int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
            int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
            int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
            for (int l = 0; l < i; ++l) {
                for (int i1 = 0; i1 < j; ++i1) {
                    for (int j1 = 0; j1 < k; ++j1) {
                        double d4 = ((double)l + 0.5) / (double)i;
                        double d5 = ((double)i1 + 0.5) / (double)j;
                        double d6 = ((double)j1 + 0.5) / (double)k;
                        double d7 = d4 * d1 + minX;
                        double d8 = d5 * d2 + minY;
                        double d9 = d6 * d3 + minZ;
                        manager.add(new CustomTintTerrainParticle(clientLevel, (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos).updateSprite(state, pos));
                    }
                }
            }
        });
        return true;
    }
}

