/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.BlockBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;

public class ControllerBlock
extends BlockBase
implements ISneakItemInteractionBlock,
EntityBlock {
    public ControllerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(3.0f, 6.0f));
    }

    public void appendHoverText(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.getItem().getDescriptionId() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntityBase.class).ifPresent(ControllerBlockEntityBase::detachFromStoragesAndUnlinkBlocks);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide()) {
            return;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(ControllerBlockEntityBase::searchAndAddBoundables);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(controller -> {
            AtomicBoolean appliedUpgrade = new AtomicBoolean(false);
            controller.getStoragePositions().forEach(storagePos -> WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)storagePos, StorageBlockEntity.class).ifPresent(be -> {
                Block patt3393$temp = be.getBlockState().getBlock();
                if (patt3393$temp instanceof StorageBlockBase) {
                    StorageBlockBase storageblock = (StorageBlockBase)patt3393$temp;
                    ItemStack itemInHand = player.getItemInHand(hand);
                    if (storageblock.tryAddSingleUpgrade(player, hand, (StorageBlockEntity)be, itemInHand)) {
                        appliedUpgrade.set(true);
                    } else {
                        StorageTierUpgradeItem storageTierUpgradeItem;
                        Item patt3637$temp = itemInHand.getItem();
                        if (patt3637$temp instanceof StorageTierUpgradeItem && (storageTierUpgradeItem = (StorageTierUpgradeItem)patt3637$temp).tryUpgradeStorage(itemInHand, level, (BlockPos)storagePos, be.getBlockState(), player) == InteractionResult.SUCCESS) {
                            appliedUpgrade.set(true);
                        }
                    }
                }
            }));
            if (!appliedUpgrade.get()) {
                controller.depositPlayerItems(player, hand);
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean trySneakItemInteraction(Player player, InteractionHand hand, BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemInHand) {
        if (level.isClientSide()) {
            return false;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).map(controller -> {
            AtomicBoolean result = new AtomicBoolean(false);
            controller.getStoragePositions().forEach(storagePos -> {
                StorageBlockBase storageblock;
                Block block = level.getBlockState(storagePos).getBlock();
                if (block instanceof StorageBlockBase && (storageblock = (StorageBlockBase)block).tryFillUpgrades(player, hand, level, (BlockPos)storagePos, player.getItemInHand(hand))) {
                    result.set(true);
                }
            });
            return result.get();
        }).orElse(false);
    }
}

