/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ItemContentsStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedstorage";
    private final Map<UUID, CompoundTag> storageContents = new HashMap<UUID, CompoundTag>();
    private static final ItemContentsStorage clientStorageCopy = new ItemContentsStorage();

    private ItemContentsStorage() {
    }

    public static ItemContentsStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (ItemContentsStorage)storage.computeIfAbsent(new SavedData.Factory(ItemContentsStorage::new, ItemContentsStorage::load), SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    public static ItemContentsStorage load(CompoundTag nbt) {
        ItemContentsStorage storage = new ItemContentsStorage();
        ItemContentsStorage.readStorageContents(nbt, storage);
        return storage;
    }

    private static void readStorageContents(CompoundTag nbt, ItemContentsStorage storage) {
        ListTag storageContents = nbt.getList(nbt.contains("shulkerBoxContents") ? "shulkerBoxContents" : "storageContents", 10);
        for (Tag n : storageContents) {
            CompoundTag uuidContentsPair = (CompoundTag)n;
            UUID uuid = NbtUtils.loadUUID((Tag)Objects.requireNonNull(uuidContentsPair.get("uuid")));
            CompoundTag contents = uuidContentsPair.getCompound("contents");
            storage.storageContents.put(uuid, contents);
        }
    }

    public CompoundTag save(CompoundTag compound) {
        CompoundTag ret = new CompoundTag();
        this.writeStorageContents(ret);
        return ret;
    }

    private void writeStorageContents(CompoundTag ret) {
        ListTag storageContentsNbt = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.storageContents.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.put("uuid", (Tag)NbtUtils.createUUID((UUID)entry.getKey()));
            uuidContentsPair.put("contents", (Tag)entry.getValue());
            storageContentsNbt.add((Object)uuidContentsPair);
        }
        ret.put("storageContents", (Tag)storageContentsNbt);
    }

    public CompoundTag getOrCreateStorageContents(UUID storageUuid) {
        return this.storageContents.computeIfAbsent(storageUuid, uuid -> {
            this.setDirty();
            return new CompoundTag();
        });
    }

    public void removeStorageContents(UUID storageUuid) {
        this.storageContents.remove(storageUuid);
        this.setDirty();
    }

    public void setStorageContents(UUID storageUuid, CompoundTag contents) {
        this.storageContents.put(storageUuid, contents);
        this.setDirty();
    }
}

