/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageIOBlockEntity
extends BlockEntity
implements IControllerBoundable,
ILinkable {
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    @Nullable
    private BlockCapabilityCache<IItemHandler, Direction> controllerItemHandlerCache;

    protected StorageIOBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public StorageIOBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.STORAGE_IO_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerItemHandlerCache = null;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.setChanged();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.removeControllerPos();
        this.setChanged();
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.controllerItemHandlerCache = null;
        this.setChanged();
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return this.getLevel();
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public boolean canBeConnected() {
        return this.isLinked() || this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.getBlockPos());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public void removeFromController() {
        if (!this.level.isClientSide()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((BlockGetter)this.level, (BlockPos)p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeNonConnectingBlock(this.getBlockPos()));
            this.removeControllerPos();
        }
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.putBoolean("isLinkedToController", this.isLinkedToController);
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((CompoundTag)tag, (String)"isLinkedToController").orElse(false);
    }

    protected void invalidateItemHandlerCache() {
        this.controllerItemHandlerCache = null;
        this.invalidateCapabilities();
    }

    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        Level level;
        if (this.getControllerPos().isEmpty()) {
            return null;
        }
        if (this.controllerItemHandlerCache == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.controllerItemHandlerCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getControllerPos().get(), (Object)Direction.UP, () -> !this.isRemoved(), this::invalidateItemHandlerCache);
        }
        if (this.controllerItemHandlerCache != null) {
            return (IItemHandler)this.controllerItemHandlerCache.getCapability();
        }
        return WorldHelper.getBlockEntity((BlockGetter)this.getLevel(), (BlockPos)this.getControllerPos().get(), ControllerBlockEntity.class).map(c -> c.getExternalItemHandler(side)).orElse(null);
    }
}

