/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockBase
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final Map<WoodType, BlockFamily> CUSTOM_TEXTURE_WOOD_TYPES = ImmutableMap.builder().put((Object)WoodType.ACACIA, (Object)BlockFamilies.ACACIA_PLANKS).put((Object)WoodType.BIRCH, (Object)BlockFamilies.BIRCH_PLANKS).put((Object)WoodType.CRIMSON, (Object)BlockFamilies.CRIMSON_PLANKS).put((Object)WoodType.DARK_OAK, (Object)BlockFamilies.DARK_OAK_PLANKS).put((Object)WoodType.JUNGLE, (Object)BlockFamilies.JUNGLE_PLANKS).put((Object)WoodType.OAK, (Object)BlockFamilies.OAK_PLANKS).put((Object)WoodType.SPRUCE, (Object)BlockFamilies.SPRUCE_PLANKS).put((Object)WoodType.WARPED, (Object)BlockFamilies.WARPED_PLANKS).put((Object)WoodType.MANGROVE, (Object)BlockFamilies.MANGROVE_PLANKS).put((Object)WoodType.CHERRY, (Object)BlockFamilies.CHERRY_PLANKS).put((Object)WoodType.BAMBOO, (Object)BlockFamilies.BAMBOO_PLANKS).build();

    protected WoodStorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties, numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
    }

    public void addNameWoodAndTintData(ItemStack stack, BlockGetter level, BlockPos pos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> this.addNameWoodAndTintData(stack, (WoodStorageBlockEntity)be));
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        if (be instanceof WoodStorageBlockEntity) {
            WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)be;
            this.addNameWoodAndTintData(stack, wbe);
            if (wbe.isPacked() || WoodStorageBlockBase.shouldNonEmptyDropPacked(wbe)) {
                StorageWrapper storageWrapper = be.getStorageWrapper();
                UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
                CompoundTag storageContents = wbe.getStorageContentsTag();
                if (!storageContents.isEmpty()) {
                    ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                    NBTHelper.setUniqueId((ItemStack)stack, (String)"uuid", (UUID)storageUuid);
                }
                WoodStorageBlockItem.setPacked(stack, true);
                StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
            }
        }
    }

    private static boolean shouldNonEmptyDropPacked(WoodStorageBlockEntity wbe) {
        if (Boolean.FALSE.equals(Config.COMMON.dropPacked.get())) {
            return false;
        }
        return !InventoryHelper.isEmpty((IItemHandler)wbe.getStorageWrapper().getInventoryHandler()) || !InventoryHelper.isEmpty((IItemHandler)wbe.getStorageWrapper().getUpgradeHandler());
    }

    private void addNameWoodAndTintData(ItemStack stack, WoodStorageBlockEntity wbe) {
        Item item = stack.getItem();
        if (item instanceof ITintableBlockItem) {
            int accentColor;
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            int mainColor = wbe.getStorageWrapper().getMainColor();
            if (mainColor > -1) {
                tintableBlockItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = wbe.getStorageWrapper().getAccentColor()) > -1) {
                tintableBlockItem.setAccentColor(stack, accentColor);
            }
        }
        if (wbe.hasCustomName()) {
            stack.setHoverName(wbe.getCustomName());
        }
        wbe.getWoodType().ifPresent(n -> WoodStorageBlockItem.setWoodType(stack, n));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (!Config.CLIENT_SPEC.isLoaded() || Boolean.TRUE.equals(Config.CLIENT.showSingleWoodVariantOnly.get())) {
            itemConsumer.accept(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), WoodType.ACACIA));
        } else {
            CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> itemConsumer.accept(WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), woodType)));
        }
        if (this.isBasicTier() || Boolean.TRUE.equals(!Config.CLIENT_SPEC.isLoaded() || (Boolean)Config.CLIENT.showHigherTierTintedVariants.get() != false)) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack storageStack = new ItemStack((ItemLike)this);
                Item item = storageStack.getItem();
                if (item instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                    tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])color.getTextureDiffuseColors()));
                    tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])color.getTextureDiffuseColors()));
                }
                itemConsumer.accept(storageStack);
            }
            ItemStack storageStack = new ItemStack((ItemLike)this);
            Item item = storageStack.getItem();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.setMainColor(storageStack, ColorHelper.getColor((float[])DyeColor.YELLOW.getTextureDiffuseColors()));
                tintableBlockItem.setAccentColor(storageStack, ColorHelper.getColor((float[])DyeColor.LIME.getTextureDiffuseColors()));
            }
            itemConsumer.accept(storageStack);
        }
    }

    private boolean isBasicTier() {
        return this == ModBlocks.BARREL.get() || this == ModBlocks.CHEST.get() || this == ModBlocks.LIMITED_BARREL_1.get() || this == ModBlocks.LIMITED_BARREL_2.get() || this == ModBlocks.LIMITED_BARREL_3.get() || this == ModBlocks.LIMITED_BARREL_4.get();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.addNameWoodAndTintData(stack, (BlockGetter)level, pos);
        return stack;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.setBeingUpgraded(true);
                be.load(itemContentsStorage.getOrCreateStorageContents((UUID)uuid));
                itemContentsStorage.removeStorageContents((UUID)uuid);
            });
            if (stack.hasCustomHoverName()) {
                be.setCustomName(stack.getHoverName());
            }
            this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.getOffhandItem().getItem() == ModItems.STORAGE_TOOL.get()) {
                StorageToolItem.useOffHandOnPlaced(placer.getOffhandItem(), be);
            }
            be.setBeingUpgraded(false);
        });
    }

    protected void setRenderBlockRenderProperties(ItemStack stack, WoodStorageBlockEntity be) {
        WoodStorageBlockItem.getWoodType(stack).ifPresent(be::setWoodType);
        StorageBlockItem.getMainColorFromStack(stack).ifPresent(be.getStorageWrapper()::setMainColor);
        StorageBlockItem.getAccentColorFromStack(stack).ifPresent(be.getStorageWrapper()::setAccentColor);
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockState ret = super.playerWillDestroy(level, pos, state, player);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            if (Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                wbe.setPacked(true);
                if (!(!player.isCreative() || InventoryHelper.isEmpty((IItemHandler)wbe.getStorageWrapper().getInventoryHandler()) && InventoryHelper.isEmpty((IItemHandler)wbe.getStorageWrapper().getUpgradeHandler()))) {
                    ItemStack drop = new ItemStack((ItemLike)this);
                    this.addDropData(drop, (StorageBlockEntity)wbe);
                    ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
                    itementity.setDefaultPickUpDelay();
                    level.addFreshEntity((Entity)itementity);
                }
            }
        });
        return ret;
    }

    protected boolean tryItemInteraction(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (stackInHand.getItem() == ModItems.PACKING_TAPE.get()) {
            if (Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                player.displayClientMessage((Component)Component.translatable((String)"gui.sophisticatedstorage.status.packing_tape_disabled"), true);
            } else {
                this.packStorage(player, hand, b, stackInHand);
            }
            return true;
        }
        return this.tryAddUpgrade(player, hand, b, stackInHand, facing, hitResult);
    }

    protected void packStorage(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        if (!player.isCreative()) {
            stackInHand.setDamageValue(stackInHand.getDamageValue() + 1);
            if (stackInHand.getDamageValue() >= stackInHand.getMaxDamage()) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
        }
        b.setPacked(true);
        BlockState blockState = b.getBlockState();
        Block block = blockState.getBlock();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            if (((Boolean)blockState.getValue((Property)StorageBlockBase.TICKING)).booleanValue()) {
                storageBlock.setTicking(player.level(), b.getBlockPos(), blockState, false);
            }
        }
        b.removeFromController();
        WorldHelper.notifyBlockUpdate((BlockEntity)b);
    }
}

