/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;

public class LimitedBarrelScreen
extends StorageScreen {
    public static final ResourceLocation GUI_BACKGROUNDS = SophisticatedStorage.getRL("textures/gui/limited_barrels.png");
    public static final TextureBlitData LIMITED_I_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(0, 0), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_II_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(84, 0), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_III_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(0, 82), new Dimension(84, 82));
    public static final TextureBlitData LIMITED_IV_BACKGROUND = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(84, 82), new Dimension(84, 82));
    public static final TextureBlitData SMALL_BAR_FILL = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(171, 0), new Dimension(3, 28));
    public static final TextureBlitData LARGE_BAR_FILL = new TextureBlitData(GUI_BACKGROUNDS, Dimension.SQUARE_256, new UV(168, 0), new Dimension(3, 68));
    public static final int STORAGE_SLOTS_HEIGHT = 82;
    private static final int MIDDLE_OF_STORAGE_SLOTS = 59;

    public LimitedBarrelScreen(StorageContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void drawSlotBg(GuiGraphics guiGraphics, int x, int y) {
        LimitedBarrelScreen.drawSlotBg(this, guiGraphics, x, y, ((StorageContainerMenu)this.getMenu()).getNumberOfStorageInventorySlots());
    }

    public static void drawSlotBg(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int slotsNumber) {
        TextureBlitData backgroundTexture = LimitedBarrelScreen.getBackgroundTexture(slotsNumber);
        GuiHelper.blit((GuiGraphics)guiGraphics, (int)(x + screen.getXSize() / 2 - backgroundTexture.getWidth() / 2 - 1), (int)(y + 17), (TextureBlitData)backgroundTexture);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        switch (((StorageContainerMenu)this.getMenu()).getNumberOfStorageInventorySlots()) {
            case 1: {
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 24, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(0), LARGE_BAR_FILL, false);
                break;
            }
            case 2: {
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 24, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(0), SMALL_BAR_FILL, false);
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 64, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(1), SMALL_BAR_FILL, false);
                break;
            }
            case 3: {
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 24, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(0), SMALL_BAR_FILL, false);
                this.renderBar(guiGraphics, this.imageWidth / 2 - 37 - 5, 64, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(1), SMALL_BAR_FILL, true);
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 64, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(2), SMALL_BAR_FILL, false);
                break;
            }
            case 4: {
                this.renderBar(guiGraphics, this.imageWidth / 2 - 37 - 5, 24, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(0), SMALL_BAR_FILL, true);
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 24, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(1), SMALL_BAR_FILL, false);
                this.renderBar(guiGraphics, this.imageWidth / 2 - 37 - 5, 64, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(2), SMALL_BAR_FILL, true);
                this.renderBar(guiGraphics, this.imageWidth / 2 + 37, 64, ((StorageContainerMenu)this.getMenu()).getSlotFillPercentage(3), SMALL_BAR_FILL, false);
            }
        }
    }

    private static TextureBlitData getBackgroundTexture(int slotsNumber) {
        return switch (slotsNumber) {
            case 1 -> LIMITED_I_BACKGROUND;
            case 2 -> LIMITED_II_BACKGROUND;
            case 3 -> LIMITED_III_BACKGROUND;
            case 4 -> LIMITED_IV_BACKGROUND;
            default -> throw new IllegalStateException("Unexpected number of limited barrel slots: " + slotsNumber);
        };
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return 82;
    }

    protected void updateStorageSlotsPositions() {
        LimitedBarrelScreen.updateSlotPositions(this.getMenu(), ((StorageContainerMenu)this.getMenu()).getNumberOfStorageInventorySlots(), this.imageWidth);
    }

    public static void updateSlotPositions(AbstractContainerMenu menu, int slotNumber, int imageWidth) {
        int halfWidth = imageWidth / 2;
        if (slotNumber == 1) {
            Slot slot = menu.getSlot(0);
            slot.x = halfWidth - 9;
            slot.y = 50;
        } else if (slotNumber == 2) {
            Slot slot = menu.getSlot(0);
            slot.x = halfWidth - 9;
            slot.y = 30;
            slot = menu.getSlot(1);
            slot.x = halfWidth - 9;
            slot.y = 70;
        } else if (slotNumber == 3) {
            Slot slot = menu.getSlot(0);
            slot.x = halfWidth - 9;
            slot.y = 30;
            slot = menu.getSlot(1);
            slot.x = halfWidth - 29;
            slot.y = 70;
            slot = menu.getSlot(2);
            slot.x = halfWidth + 11;
            slot.y = 70;
        } else if (slotNumber == 4) {
            Slot slot = menu.getSlot(0);
            slot.x = halfWidth - 29;
            slot.y = 30;
            slot = menu.getSlot(1);
            slot.x = halfWidth + 11;
            slot.y = 30;
            slot = menu.getSlot(2);
            slot.x = halfWidth - 29;
            slot.y = 70;
            slot = menu.getSlot(3);
            slot.x = halfWidth + 11;
            slot.y = 70;
        }
    }

    private void renderBar(GuiGraphics guiGraphics, int x, int y, float percentage, TextureBlitData barTexture, boolean left) {
        int barHeight = (int)((float)barTexture.getHeight() * percentage);
        int yOffset = barTexture.getHeight() - barHeight;
        guiGraphics.blit(barTexture.getTextureName(), x, y + yOffset, (float)barTexture.getU(), (float)(barTexture.getV() + yOffset), barTexture.getWidth(), barHeight, barTexture.getTextureWidth(), barTexture.getTextureHeight());
        String text = String.valueOf((int)(percentage * 100.0f)) + "%";
        int percentageX = x;
        percentageX = left ? (percentageX -= 2 + this.minecraft.font.width(text)) : (percentageX += 6);
        guiGraphics.drawString(this.font, text, percentageX, y + barTexture.getHeight() / 2 - 3, 0x2C2C2C, false);
    }

    protected boolean shouldShowSortButtons() {
        return false;
    }
}

