/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.GameData;
import net.p3pp3rf1y.sophisticatedstorage.init.ModParticles;

public class CustomTintTerrainParticleData
extends ParticleType<CustomTintTerrainParticleData>
implements ParticleOptions {
    private final BlockState state;
    private final BlockPos pos;
    public static final ParticleOptions.Deserializer<CustomTintTerrainParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CustomTintTerrainParticleData>(){

        public CustomTintTerrainParticleData fromCommand(ParticleType<CustomTintTerrainParticleData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect('|');
            BlockState blockState = Objects.requireNonNull(BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)reader, (boolean)false).blockState());
            reader.expect('|');
            return new CustomTintTerrainParticleData(blockState, this.fromString(reader.readUnquotedString()));
        }

        private BlockPos fromString(String value) {
            String[] split = value.split(",");
            return BlockPos.containing((double)Double.parseDouble(split[0]), (double)Double.parseDouble(split[1]), (double)Double.parseDouble(split[2]));
        }

        public CustomTintTerrainParticleData fromNetwork(ParticleType<CustomTintTerrainParticleData> particleType, FriendlyByteBuf buffer) {
            return new CustomTintTerrainParticleData(Objects.requireNonNull((BlockState)GameData.getBlockStateIDMap().byId(buffer.readVarInt())), buffer.readBlockPos());
        }
    };
    private final Codec<CustomTintTerrainParticleData> codec = RecordCodecBuilder.create(particleDataInstance -> particleDataInstance.group((App)BlockState.CODEC.fieldOf("state").forGetter(data -> data.state), (App)BlockPos.CODEC.fieldOf("pos").forGetter(data -> data.pos)).apply((Applicative)particleDataInstance, CustomTintTerrainParticleData::new));

    public CustomTintTerrainParticleData() {
        this(Blocks.AIR.defaultBlockState(), BlockPos.ZERO);
    }

    public CustomTintTerrainParticleData(BlockState state, BlockPos pos) {
        super(false, DESERIALIZER);
        this.state = state;
        this.pos = pos;
    }

    public CustomTintTerrainParticleData getType() {
        return ModParticles.TERRAIN_PARTICLE.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeVarInt(GameData.getBlockStateIDMap().getId((Object)this.state));
        buffer.writeBlockPos(this.pos);
    }

    public String writeToString() {
        return BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.getType()) + "|" + BlockStateParser.serialize((BlockState)this.state) + "|" + this.pos.toShortString();
    }

    public Codec<CustomTintTerrainParticleData> codec() {
        return this.codec;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

