/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ChestItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final LoadingCache<BlockItem, ChestBlockEntity> chestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<BlockItem, ChestBlockEntity>(){

        public ChestBlockEntity load(BlockItem blockItem) {
            return new ChestBlockEntity(BlockPos.ZERO, (BlockState)blockItem.getBlock().defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH));
        }
    });
    private final LoadingCache<DoubleChestBlockEntityKey, ChestBlockEntity> doubleChestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<DoubleChestBlockEntityKey, ChestBlockEntity>(){

        public ChestBlockEntity load(DoubleChestBlockEntityKey key) {
            return new ChestBlockEntity(BlockPos.ZERO, (BlockState)((BlockState)key.blockItem().getBlock().defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH)).setValue(ChestBlock.TYPE, (Comparable)key.chestType()));
        }
    });

    public static IClientItemExtensions getItemRenderProperties() {
        return new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ChestItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
            }
        };
    }

    public ChestItemRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
        this.blockEntityRenderDispatcher = blockEntityRenderDispatcher;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (ChestBlockItem.isDoubleChest(stack)) {
            ChestBlockEntity leftChestBlockEntity = (ChestBlockEntity)this.doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(blockItem, ChestType.LEFT));
            poseStack.pushPose();
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.translate(0.72, 0.0, 0.0);
            this.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, leftChestBlockEntity);
            ChestBlockEntity rightChestBlockEntity = (ChestBlockEntity)this.doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(blockItem, ChestType.RIGHT));
            poseStack.translate(-1.0, 0.0, 0.0);
            this.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, rightChestBlockEntity);
            poseStack.popPose();
            return;
        }
        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)this.chestBlockEntities.getUnchecked((Object)blockItem);
        this.renderBlockEntity(stack, poseStack, buffer, packedLight, packedOverlay, chestBlockEntity);
    }

    private void renderBlockEntity(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ChestBlockEntity chestBlockEntity) {
        BlockEntityRenderer blockentityrenderer;
        Optional<WoodType> woodType;
        Item item = stack.getItem();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            chestBlockEntity.getStorageWrapper().setMainColor(tintableBlockItem.getMainColor(stack).orElse(-1));
            chestBlockEntity.getStorageWrapper().setAccentColor(tintableBlockItem.getAccentColor(stack).orElse(-1));
        }
        if ((woodType = WoodStorageBlockItem.getWoodType(stack)).isPresent() || !chestBlockEntity.getStorageWrapper().hasAccentColor() || !chestBlockEntity.getStorageWrapper().hasMainColor()) {
            chestBlockEntity.setWoodType(woodType.orElse(WoodType.ACACIA));
        }
        chestBlockEntity.setPacked(WoodStorageBlockItem.isPacked(stack));
        if (StorageBlockItem.showsTier(stack) != chestBlockEntity.shouldShowTier()) {
            chestBlockEntity.toggleTierVisiblity();
        }
        if ((blockentityrenderer = this.blockEntityRenderDispatcher.getRenderer((BlockEntity)chestBlockEntity)) != null) {
            blockentityrenderer.render((BlockEntity)chestBlockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    private record DoubleChestBlockEntityKey(BlockItem blockItem, ChestType chestType) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleChestBlockEntityKey that = (DoubleChestBlockEntityKey)o;
            return Objects.equal((Object)this.blockItem, (Object)that.blockItem) && this.chestType == that.chestType;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.blockItem, this.chestType});
        }
    }
}

