/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.model.ElementsModel;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;
import org.apache.logging.log4j.util.Supplier;

public class CompositeElementsModel
extends BlockModel {
    private final List<BlockElement> elements = new ArrayList<BlockElement>();

    public CompositeElementsModel(@Nullable ResourceLocation parentLocation, Map<String, Either<Material, String>> textureMap) {
        super(parentLocation, Collections.emptyList(), textureMap, Boolean.valueOf(true), null, ItemTransforms.NO_TRANSFORMS, Collections.emptyList());
    }

    public BakedModel bake(ModelBaker modelBaker, BlockModel owner, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation, boolean guiLight3d) {
        if (this.getRootModel() == ModelBakery.BLOCK_ENTITY_MARKER) {
            TextureAtlasSprite particleSprite = spriteGetter.apply(this.getMaterial("particle"));
            return new BuiltInModel(this.getTransforms(), this.getOverrides(modelBaker, owner, spriteGetter), particleSprite, this.getGuiLight().lightLikeBlock());
        }
        ElementsModel elementsModel = new ElementsModel(this.getElements());
        return elementsModel.bake((IGeometryBakingContext)this.customData, modelBaker, spriteGetter, modelState, this.getOverrides(modelBaker, owner, spriteGetter), modelLocation);
    }

    public List<BlockElement> getElements() {
        return this.elements;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter) {
        super.resolveParents(modelGetter);
        this.copyElementsFromAllIncludedModels();
        this.copyTexturesFromAllIncludedModels();
    }

    private void copyElementsFromAllIncludedModels() {
        if (this.parent != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.elements.addAll(this.parent.getElements());
            if (this.parent.customData.hasCustomGeometry() && (iUnbakedGeometry = this.parent.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                this.elements.addAll(simpleCompositeModel.getElements());
            }
        }
    }

    private void copyTexturesFromAllIncludedModels() {
        if (this.parent != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.parent.textureMap.forEach(this.textureMap::putIfAbsent);
            if (this.parent.customData.hasCustomGeometry() && (iUnbakedGeometry = this.parent.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                simpleCompositeModel.getTextures().forEach(this.textureMap::putIfAbsent);
            }
        }
    }

    public Material getMaterial(String textureName) {
        if (textureName.charAt(0) == '#') {
            textureName = textureName.substring(1);
        }
        ArrayList visitedTextureReferences = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.findTexture(textureName)).left()).isPresent()) {
            textureName = either.right().orElse("");
            if (visitedTextureReferences.contains(textureName)) {
                String finalTextureName = textureName;
                SophisticatedStorage.LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Supplier[]{() -> Joiner.on((String)"->").join((Iterable)visitedTextureReferences), () -> finalTextureName, () -> this.name});
                return new Material(InventoryMenu.BLOCK_ATLAS, MissingTextureAtlasSprite.getLocation());
            }
            visitedTextureReferences.add(textureName);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> findTexture(String textureName) {
        CompositeElementsModel blockmodel = this;
        while (blockmodel != null) {
            Either either = (Either)blockmodel.textureMap.get(textureName);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.parent;
        }
        return Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, MissingTextureAtlasSprite.getLocation()));
    }
}

