/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ControllerRenderer
implements BlockEntityRenderer<ControllerBlockEntity> {
    public void render(ControllerBlockEntity controller, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.DEBUG_TOOL.get())).ifPresent(storageTool -> this.renderConnectedStorageBlocksInfo(controller, Direction.orderedByNearest((Entity)player)[0].getOpposite(), poseStack, bufferSource));
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).ifPresent(storageTool -> {
            if (StorageToolItem.getMode(storageTool) != StorageToolItem.Mode.LINK) {
                return;
            }
            if (StorageToolItem.getControllerLink(storageTool).map(controllerPos -> controllerPos.equals((Object)controller.getBlockPos())).orElse(false).booleanValue()) {
                this.renderBlockOutline(controller.getBlockPos(), controller.getBlockPos(), level, poseStack, bufferSource, DyeColor.LIGHT_BLUE.getTextureDiffuseColors());
            }
            this.renderLinkedBlocksOutline(controller, level, poseStack, bufferSource);
        });
    }

    private void renderConnectedStorageBlocksInfo(ControllerBlockEntity controller, Direction playerLookDirection, PoseStack poseStack, MultiBufferSource bufferSource) {
        Font fontRenderer = Minecraft.getInstance().font;
        double zScale = 0.001;
        float scale = 0.015f;
        int storageOrder = 1;
        for (BlockPos position : controller.getStoragePositions()) {
            BlockPos controllerPos = controller.getBlockPos();
            double translateX = (double)position.getX() + 0.5 - (double)controllerPos.getX() + 0.501 * (double)playerLookDirection.getNormal().getX();
            double translateY = (double)position.getY() + 0.5 - (double)controllerPos.getY() + 0.501 * (double)playerLookDirection.getNormal().getY();
            double translateZ = (double)position.getZ() + 0.5 - (double)controllerPos.getZ() + 0.501 * (double)playerLookDirection.getNormal().getZ();
            poseStack.pushPose();
            poseStack.translate(translateX, translateY, translateZ);
            Quaternionf rotation = playerLookDirection.getRotation();
            rotation.mul((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(rotation);
            poseStack.translate(-0.45f, 0.45f, 0.0f);
            poseStack.scale(scale, -scale, (float)zScale);
            fontRenderer.drawInBatch("Order: " + storageOrder, 0.0f, 0.0f, DyeColor.WHITE.getTextColor(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.translate(0.0f, 10.0f, 0.0f);
            fontRenderer.drawInBatch("Slots: " + controller.getSlots(storageOrder - 1), 0.0f, 0.0f, DyeColor.WHITE.getTextColor(), false, poseStack.last().pose(), bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.popPose();
            ++storageOrder;
        }
    }

    private void renderLinkedBlocksOutline(ControllerBlockEntity controller, ClientLevel level, PoseStack poseStack, MultiBufferSource bufferSource) {
        controller.getLinkedBlocks().forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            VoxelShape shape = state.getBlock().getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
            this.renderLineBetweenBlocks(controller.getBlockPos(), (BlockPos)pos, shape, poseStack, bufferSource, DyeColor.LIME.getTextureDiffuseColors());
            this.renderBlockOutline(controller.getBlockPos(), (BlockPos)pos, shape, poseStack, bufferSource, DyeColor.LIME.getTextureDiffuseColors());
        });
    }

    private void renderLineBetweenBlocks(BlockPos initialPos, BlockPos pos, VoxelShape shape, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        if (shape.isEmpty()) {
            return;
        }
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        Vec3 center = shape.bounds().getCenter();
        VertexConsumer buffer = bufferSource.getBuffer(LineRenderType.LINES);
        Matrix4f matrix4f = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        float normalX = (float)((double)(pos.getX() - initialPos.getX()) + (0.5 - center.x()));
        float normalY = (float)((double)(pos.getY() - initialPos.getY()) + (0.5 - center.y()));
        float normalZ = (float)((double)(pos.getZ() - initialPos.getZ()) + (0.5 - center.z()));
        buffer.vertex(matrix4f, 0.5f, 0.5f, 0.5f).color(red, green, blue, 255.0f).normal(matrix3f, normalX, normalY, normalZ).endVertex();
        buffer.vertex(matrix4f, (float)((double)(pos.getX() - initialPos.getX()) + center.x()), (float)((double)(pos.getY() - initialPos.getY()) + center.y()), (float)((double)(pos.getZ() - initialPos.getZ()) + center.z())).color(red, green, blue, 255.0f).normal(matrix3f, normalX, normalY, normalZ).endVertex();
    }

    private void renderBlockOutline(BlockPos controllerPos, BlockPos pos, ClientLevel level, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        BlockState state = level.getBlockState(pos);
        VoxelShape shape = state.getBlock().getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
        this.renderBlockOutline(controllerPos, pos, shape, poseStack, bufferSource, color);
    }

    private void renderBlockOutline(BlockPos controllerPos, BlockPos pos, VoxelShape shape, PoseStack poseStack, MultiBufferSource bufferSource, float[] color) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(LineRenderType.LINES);
        float red = color[0];
        float green = color[1];
        float blue = color[2];
        LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)shape, (double)((double)(-controllerPos.getX()) + (double)pos.getX()), (double)((double)(-controllerPos.getY()) + (double)pos.getY()), (double)((double)(-controllerPos.getZ()) + (double)pos.getZ()), (float)red, (float)green, (float)blue, (float)1.0f);
    }

    public boolean shouldRenderOffScreen(ControllerBlockEntity blockEntity) {
        return true;
    }

    public AABB getRenderBoundingBox(ControllerBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(15.0);
    }

    private static class LineRenderType
    extends RenderType {
        private static final RenderType LINES = RenderType.create((String)"storage_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setDepthTestState(NO_DEPTH_TEST).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(VIEW_OFFSET_Z_LAYERING).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));

        public LineRenderType(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }
}

