/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RenderHelper {
    private static final Cache<Integer, TextureAtlasSprite> SPRITE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RenderHelper() {
    }

    public static TextureAtlasSprite getSprite(ResourceLocation blockName, @Nullable Direction direction, RandomSource rand) {
        int hash = blockName.hashCode();
        TextureAtlasSprite sprite = (TextureAtlasSprite)SPRITE_CACHE.getIfPresent((Object)(hash = hash * 31 + (direction == null ? 0 : direction.hashCode())));
        if (sprite == null) {
            sprite = RenderHelper.parseSprite(blockName, direction, rand);
            SPRITE_CACHE.put((Object)hash, (Object)sprite);
        }
        return sprite;
    }

    private static TextureAtlasSprite parseSprite(ResourceLocation blockName, @Nullable Direction direction, RandomSource rand) {
        BlockState blockState = RenderHelper.getDefaultBlockState(blockName);
        TextureAtlasSprite sprite = RenderHelper.parseSpriteFromModel(blockState, direction, rand);
        if (sprite == null) {
            sprite = Minecraft.getInstance().getModelManager().getMissingModel().getParticleIcon(ModelData.EMPTY);
        }
        return sprite;
    }

    @Nullable
    private static TextureAtlasSprite parseSpriteFromModel(BlockState blockState, @Nullable Direction direction, RandomSource rand) {
        TextureAtlasSprite sprite = null;
        BakedModel blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState);
        try {
            for (RenderType layer : blockModel.getRenderTypes(blockState, rand, ModelData.EMPTY)) {
                List culledQuads = blockModel.getQuads(blockState, direction, rand, ModelData.EMPTY, layer);
                if (!culledQuads.isEmpty()) {
                    return ((BakedQuad)culledQuads.get(0)).getSprite();
                }
                for (BakedQuad bakedQuad : blockModel.getQuads(blockState, null, rand)) {
                    if (sprite == null) {
                        sprite = bakedQuad.getSprite();
                    }
                    if (bakedQuad.getDirection() != direction) continue;
                    return bakedQuad.getSprite();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sprite == null) {
            try {
                sprite = blockModel.getParticleIcon(ModelData.EMPTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sprite;
    }

    private static BlockState getDefaultBlockState(ResourceLocation blockName) {
        return BuiltInRegistries.BLOCK.getOptional(blockName).map(Block::defaultBlockState).orElse(Blocks.AIR.defaultBlockState());
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha) {
        RenderHelper.renderQuad(consumer, pose, normal, packedOverlay, packedLight, alpha, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha, float minU, float minV, float maxU, float maxV) {
        boolean minX = false;
        int minY = 0;
        int maxY = 1;
        boolean maxX = true;
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)minX, packedOverlay, packedLight, maxU, minV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)minX, packedOverlay, packedLight, maxU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, minY, (float)maxX, packedOverlay, packedLight, minU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, consumer, maxY, (float)maxX, packedOverlay, packedLight, minU, minV, alpha);
    }

    private static void addVertex(Matrix4f pose, Vector3f normal, VertexConsumer consumer, int pY, float pX, int packedOverlay, int packedLight, float u, float v, float alpha) {
        Vector4f pos = new Vector4f(pX, (float)pY, 0.0f, 1.0f);
        pose.transform(pos);
        consumer.vertex(pos.x(), pos.y(), pos.z(), 1.0f, 1.0f, 1.0f, alpha, u, v, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }
}

