/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class TranslucentVertexConsumer
extends DefaultedVertexConsumer {
    public static final RenderType TRANSLUCENT = RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS);
    private final VertexConsumer delegate;
    private static BiFunction<MultiBufferSource, Integer, VertexConsumer> factory = TranslucentVertexConsumer::new;

    public static void setFactory(BiFunction<MultiBufferSource, Integer, VertexConsumer> factory) {
        TranslucentVertexConsumer.factory = factory;
    }

    public TranslucentVertexConsumer(VertexConsumer delegate, int alpha) {
        this.delegate = delegate;
        this.defaultA = alpha;
    }

    public TranslucentVertexConsumer(MultiBufferSource buffer, int alpha) {
        this(buffer.getBuffer(TRANSLUCENT), alpha);
    }

    static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha) {
        return renderType -> factory.apply(buffer, alpha);
    }

    public static VertexConsumer getVertexConsumer(MultiBufferSource buffer, int alpha) {
        return factory.apply(buffer, alpha);
    }

    public void vertex(float pX, float pY, float pZ, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        super.vertex(pX, pY, pZ, red, green, blue, (float)this.defaultA / 256.0f, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
    }

    public VertexConsumer vertex(double pX, double pY, double pZ) {
        return this.delegate.vertex(pX, pY, pZ);
    }

    public VertexConsumer color(int red, int green, int blue, int alpha) {
        return this.delegate.color(red, green, blue, this.defaultA);
    }

    public VertexConsumer uv(float pU, float pV) {
        return this.delegate.uv(pU, pV);
    }

    public VertexConsumer overlayCoords(int pU, int pV) {
        return this.delegate.overlayCoords(pU, pV);
    }

    public VertexConsumer uv2(int pU, int pV) {
        return this.delegate.uv2(pU, pV);
    }

    public VertexConsumer normal(float pX, float pY, float pZ) {
        return this.delegate.normal(pX, pY, pZ);
    }

    public void endVertex() {
        this.delegate.endVertex();
    }
}

