/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class BaseTierWoodenStorageIngredient
extends Ingredient {
    public static final BaseTierWoodenStorageIngredient INSTANCE = new BaseTierWoodenStorageIngredient();
    public static final Codec<BaseTierWoodenStorageIngredient> CODEC = MapCodec.unit((Object)((Object)INSTANCE)).stable().codec();

    public BaseTierWoodenStorageIngredient() {
        super(BaseTierWoodenStorageIngredient.getChestsAndBarrels(), ModBlocks.BASE_TIER_WOODEN_STORAGE_INGREDIENT_TYPE);
    }

    private static Stream<? extends Ingredient.Value> getChestsAndBarrels() {
        Stream<Object> chestsStream = Stream.empty();
        BlockItem blockItem = ModBlocks.CHEST_ITEM.get();
        if (blockItem instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)blockItem;
            ArrayList chestIngredientValues = new ArrayList();
            itemBase.addCreativeTabItems(i -> chestIngredientValues.add(new Ingredient.ItemValue(i)));
            chestsStream = chestIngredientValues.stream();
        }
        Stream<Object> barrelsStream = Stream.empty();
        BlockItem blockItem2 = ModBlocks.BARREL_ITEM.get();
        if (blockItem2 instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)blockItem2;
            ArrayList barrelIngredientValues = new ArrayList();
            itemBase.addCreativeTabItems(i -> barrelIngredientValues.add(new Ingredient.ItemValue(i)));
            barrelsStream = barrelIngredientValues.stream();
        }
        return Stream.concat(chestsStream, barrelsStream);
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && stack.is(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG);
    }
}

