/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ShulkerBoxFromChestRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public ShulkerBoxFromChestRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        return super.matches(inv, level) && this.getChest(inv).map(c -> !WoodStorageBlockItem.isPacked(c)).orElse(false) != false;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getChest(CraftingContainer inv) {
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ChestBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack shulker = super.assemble(inv, registryAccess);
        this.getChest(inv).ifPresent(chest -> {
            Item patt2024$temp;
            if (chest.hasCustomHoverName()) {
                shulker.setHoverName(chest.getHoverName());
            }
            if ((patt2024$temp = shulker.getItem()) instanceof StorageBlockItem) {
                StorageBlockItem storageBlockItem = (StorageBlockItem)patt2024$temp;
                StorageBlockItem.getMainColorFromStack(chest).ifPresent(mc -> storageBlockItem.setMainColor(shulker, (int)mc));
                StorageBlockItem.getAccentColorFromStack(chest).ifPresent(ac -> storageBlockItem.setAccentColor(shulker, (int)ac));
            }
        });
        return shulker;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModBlocks.SHULKER_BOX_FROM_CHEST_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, ShulkerBoxFromChestRecipe> {
        public Serializer() {
            super(ShulkerBoxFromChestRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

