/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;

public class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private ItemStack storageStack;

    public StackStorageWrapper() {
        super(() -> () -> {}, () -> {}, () -> {});
    }

    public static StackStorageWrapper fromData(ItemStack stack) {
        StackStorageWrapper stackStorageWrapper = (StackStorageWrapper)stack.getData(ModItems.STACK_STORAGE_WRAPPER);
        stackStorageWrapper.setStorageStack(stack);
        UUID uuid = NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").orElse(null);
        if (uuid != null) {
            CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).getCompound("storageWrapper");
            stackStorageWrapper.load(compoundtag);
            stackStorageWrapper.setContentsUuid(uuid);
        }
        return stackStorageWrapper;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    @Override
    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            NBTHelper.setUniqueId((ItemStack)this.storageStack, (String)"uuid", (UUID)contentsUuid);
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            CompoundTag storageContents = itemContentsStorage.getOrCreateStorageContents(contentsUuid);
            if (!storageContents.contains("storageWrapper")) {
                CompoundTag storageWrapperTag = new CompoundTag();
                storageWrapperTag.put(CONTENTS_TAG, (Tag)new CompoundTag());
                storageContents.put("storageWrapper", (Tag)storageWrapperTag);
            }
            this.onContentsNbtUpdated();
        }
    }

    @Override
    protected CompoundTag getContentsNbt() {
        if (this.contentsUuid == null) {
            this.contentsUuid = this.getNewUuid();
        }
        return ItemContentsStorage.get().getOrCreateStorageContents(this.contentsUuid).getCompound("storageWrapper").getCompound(CONTENTS_TAG);
    }

    @Override
    protected void onUpgradeRefresh() {
    }

    @Override
    public int getDefaultNumberOfInventorySlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    protected void loadSlotNumbers(CompoundTag tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    @Override
    public int getDefaultNumberOfUpgradeSlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    protected void setStorageStack(ItemStack storageStack) {
        this.storageStack = storageStack;
    }

    @Override
    protected boolean isAllowedInStorage(ItemStack stack) {
        if (!(this.storageStack.getItem() instanceof ShulkerBoxItem)) {
            return false;
        }
        Block block = Block.byItem((Item)stack.getItem());
        return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.getItem());
    }

    public String getStorageType() {
        return "irrelevant";
    }

    public Component getDisplayName() {
        return Component.empty();
    }
}

