/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public static final String WOOD_TYPE_TAG = "woodType";
    public static final String PACKED_TAG = "packed";

    public WoodStorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void setPacked(ItemStack storageStack, boolean packed) {
        storageStack.getOrCreateTag().putBoolean(PACKED_TAG, packed);
    }

    public static boolean isPacked(ItemStack storageStack) {
        return NBTHelper.getBoolean((ItemStack)storageStack, (String)PACKED_TAG).orElse(false);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (WoodStorageBlockItem.isPacked(stack)) {
            if (flagIn == TooltipFlag.ADVANCED) {
                StackStorageWrapper.fromData(stack).getContentsUuid().ifPresent(uuid -> tooltip.add((Component)Component.literal((String)("UUID: " + uuid)).withStyle(ChatFormatting.DARK_GRAY)));
            }
            if (!Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        if (FMLEnvironment.dist.isClient()) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(ItemStack storageStack) {
        storageStack.getOrCreateTag().remove(WOOD_TYPE_TAG);
    }

    public static Optional<WoodType> getWoodType(ItemStack storageStack) {
        return NBTHelper.getString((ItemStack)storageStack, (String)WOOD_TYPE_TAG).flatMap(woodType -> WoodType.values().filter(wt -> wt.name().equals(woodType)).findFirst());
    }

    public static ItemStack setWoodType(ItemStack storageStack, WoodType woodType) {
        storageStack.getOrCreateTag().putString(WOOD_TYPE_TAG, woodType.name());
        return storageStack;
    }

    public Component getName(ItemStack stack) {
        return WoodStorageBlockItem.getDisplayName(this.getDescriptionId(), WoodStorageBlockItem.getWoodType(stack).orElse(null));
    }

    public static Component getDisplayName(String descriptionId, @Nullable WoodType woodType) {
        if (woodType == null) {
            return Component.translatable((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return Component.translatable((String)descriptionId, (Object[])new Object[]{Component.translatable((String)("wood_name.sophisticatedstorage." + woodType.name().toLowerCase(Locale.ROOT))), " "});
    }
}

