/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.LimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;

public class OpenStorageInventoryPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedstorage", "open_storage_inventory");
    private final BlockPos pos;

    public OpenStorageInventoryPacket(BlockPos pos) {
        this.pos = pos;
    }

    public OpenStorageInventoryPacket(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateContainerMenu(w, pl), WorldHelper.getBlockEntity((BlockGetter)player.level(), (BlockPos)this.pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse((Component)Component.empty())), this.pos);
    }

    private StorageContainerMenu instantiateContainerMenu(int windowId, Player player) {
        if (player.level().getBlockState(this.pos).getBlock() instanceof LimitedBarrelBlock) {
            return new LimitedBarrelContainerMenu(windowId, player, this.pos);
        }
        return new StorageContainerMenu(windowId, player, this.pos);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }
}

