/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.network.StorageContentsPacket;

public class RequestStorageContentsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedstorage", "request_storage_contents");
    private final UUID storageUuid;

    public RequestStorageContentsPacket(UUID storageUuid) {
        this.storageUuid = storageUuid;
    }

    public RequestStorageContentsPacket(FriendlyByteBuf buffer) {
        this(buffer.readUUID());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PacketHelper.sendToPlayer((CustomPacketPayload)new StorageContentsPacket(this.storageUuid, ItemContentsStorage.get().getOrCreateStorageContents(this.storageUuid)), (ServerPlayer)serverPlayer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.storageUuid);
    }

    public ResourceLocation id() {
        return ID;
    }
}

