/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.network;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.client.render.ClientStorageContentsTooltipBase;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;

public class StorageContentsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedstorage", "storage_contents");
    private final UUID shulkerBoxUuid;
    @Nullable
    private final CompoundTag contents;

    public StorageContentsPacket(UUID shulkerBoxUuid, @Nullable CompoundTag contents) {
        this.shulkerBoxUuid = shulkerBoxUuid;
        this.contents = contents;
    }

    public StorageContentsPacket(FriendlyByteBuf buffer) {
        this(buffer.readUUID(), buffer.readNbt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(this::handlePacket);
    }

    private void handlePacket() {
        if (this.contents == null) {
            return;
        }
        ItemContentsStorage.get().setStorageContents(this.shulkerBoxUuid, this.contents);
        ClientStorageContentsTooltipBase.refreshContents();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.shulkerBoxUuid);
        buffer.writeNbt((Tag)this.contents);
    }

    public ResourceLocation id() {
        return ID;
    }
}

