/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import org.apache.commons.lang3.function.TriFunction;

public class CompressionInventoryPart
implements IInventoryPartHandler {
    public static final String NAME = "compression";
    public static final Pair<ResourceLocation, ResourceLocation> EMPTY_COMPRESSION_SLOT = new Pair((Object)InventoryMenu.BLOCK_ATLAS, (Object)SophisticatedStorage.getRL("item/empty_compression_slot"));
    private final InventoryHandler parent;
    private final InventoryPartitioner.SlotRange slotRange;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private final Runnable recipeChangeListener = () -> this.calculateStacks(false);
    private Map<Integer, SlotDefinition> slotDefinitions = new HashMap<Integer, SlotDefinition>();
    private final Map<Integer, ItemStack> calculatedStacks = new HashMap<Integer, ItemStack>();

    public CompressionInventoryPart(InventoryHandler parent, InventoryPartitioner.SlotRange slotRange, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.parent = parent;
        this.slotRange = slotRange;
        this.getMemorySettings = getMemorySettings;
        RecipeHelper.addRecipeChangeListener((Runnable)this.recipeChangeListener);
    }

    public void onInit() {
        this.calculateStacks(true);
    }

    private void calculateStacks(boolean initial) {
        this.clearCollections();
        Map<Integer, ItemStack> existingStacks = this.getExistingStacks();
        if (existingStacks.isEmpty()) {
            return;
        }
        int lastNonEmptySlot = this.getLastNonEmptySlot(existingStacks);
        this.setSlotDefinitions(this.getSlotDefinitions(existingStacks.get(lastNonEmptySlot).getItem(), lastNonEmptySlot, existingStacks), initial);
        this.compactInternalSlots();
        this.updateCalculatedStacks();
    }

    private void setSlotDefinitions(Map<Integer, SlotDefinition> definitions, boolean initial) {
        this.slotDefinitions = definitions;
        if (initial) {
            this.parent.initFilterItems();
        } else {
            this.parent.onFilterItemsChanged();
            this.slotDefinitions.forEach((slot, definition) -> this.parent.triggerOnChangeListeners(slot.intValue()));
        }
    }

    private Integer getLastNonEmptySlot(Map<Integer, ItemStack> existingStacks) {
        for (int slot = this.slotRange.firstSlot() + this.slotRange.numberOfSlots() - 1; slot >= this.slotRange.firstSlot(); --slot) {
            if (!existingStacks.containsKey(slot)) continue;
            return slot;
        }
        return -1;
    }

    private Map<Integer, SlotDefinition> getSlotDefinitions(Item firstItem, int lastSlot, Map<Integer, ItemStack> existingStacks) {
        HashMap<Integer, SlotDefinition> ret = new HashMap<Integer, SlotDefinition>();
        this.addPreviousItems(ret, lastSlot, firstItem);
        Item prevItem = firstItem;
        for (int slot = lastSlot; slot >= this.slotRange.firstSlot(); --slot) {
            if (existingStacks.containsKey(slot) && existingStacks.get(slot).getItem() != prevItem) {
                ret.clear();
                break;
            }
            Optional<RecipeHelper.CompactingShape> compressionShape = this.getCompressionShape(prevItem);
            if (!compressionShape.isPresent()) {
                ret.put(slot, new SlotDefinition(prevItem, 1, true));
                break;
            }
            RecipeHelper.CompactingShape shape = compressionShape.get();
            ret.put(slot, new SlotDefinition(prevItem, shape.getNumberOfIngredients(), true));
            prevItem = RecipeHelper.getCompactingResult((Item)prevItem, (RecipeHelper.CompactingShape)shape).getResult().getItem();
        }
        this.updateSlotLimits(ret);
        this.updateInaccessibleAndCompressible(ret, existingStacks);
        return ret;
    }

    private void updateSlotLimits(Map<Integer, SlotDefinition> definitions) {
        int lastMultiplier = 1;
        int totalLimit = 0;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            if (!definitions.containsKey(slot) || !definitions.get(slot).isAccessible()) continue;
            if (slot != this.slotRange.firstSlot()) {
                lastMultiplier = MathHelper.intMaxCappedMultiply((int)lastMultiplier, (int)definitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier);
            }
            totalLimit = MathHelper.intMaxCappedAddition((int)totalLimit, (int)MathHelper.intMaxCappedMultiply((int)lastMultiplier, (int)this.parent.getBaseStackLimit(new ItemStack((ItemLike)definitions.get((Object)Integer.valueOf((int)slot)).item))));
            definitions.get(slot).setSlotLimit(totalLimit);
        }
    }

    private void updateCalculatedStacks() {
        int totalCalculated = 0;
        boolean prevFull = false;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            if (!slotDefinition.isAccessible()) continue;
            if (!slotDefinition.isCompressible()) {
                this.calculatedStacks.put(slot, this.parent.getSlotStack(slot).copy());
                continue;
            }
            int internalCount = this.parent.getSlotStack(slot).getCount();
            totalCalculated = Integer.MAX_VALUE / slotDefinition.prevSlotMultiplier() < totalCalculated ? Integer.MAX_VALUE : totalCalculated * slotDefinition.prevSlotMultiplier();
            totalCalculated = Integer.MAX_VALUE - internalCount < totalCalculated ? Integer.MAX_VALUE : totalCalculated + internalCount;
            ItemStack calculatedStack = new ItemStack((ItemLike)slotDefinition.item(), totalCalculated);
            int internalLimit = this.parent.getBaseStackLimit(calculatedStack);
            int maxStackSize = calculatedStack.getMaxStackSize();
            if (Integer.MAX_VALUE - totalCalculated < maxStackSize) {
                calculatedStack.setCount(Integer.MAX_VALUE - (prevFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize));
            }
            this.calculatedStacks.put(slot, calculatedStack);
            prevFull = internalLimit <= internalCount;
        }
    }

    private void compactInternalSlots() {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        for (int slot = this.slotRange.firstSlot() + 1; slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            int prevStackCount;
            ItemStack slotStack = this.parent.getSlotStack(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            if (slotStack.isEmpty() || multiplier < 2) continue;
            int prevSlot = slot - 1;
            ItemStack prevStack = this.parent.getSlotStack(prevSlot);
            int stackLimit = this.parent.getBaseStackLimit(prevStack);
            int availableSpace = stackLimit - (prevStackCount = toUpdate.containsKey(prevSlot) ? ((Integer)toUpdate.get(prevSlot)).intValue() : prevStack.getCount());
            int countToInsert = Math.min(availableSpace, slotStack.getCount() / multiplier);
            if (countToInsert <= 0) continue;
            toUpdate.put(prevSlot, prevStackCount + countToInsert);
            toUpdate.put(slot, slotStack.getCount() - countToInsert * multiplier);
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private void updateInaccessibleAndCompressible(Map<Integer, SlotDefinition> definitions, Map<Integer, ItemStack> existingStacks) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            definitions.computeIfAbsent(slot, s -> {
                if (existingStacks.containsKey(s)) {
                    return new SlotDefinition(((ItemStack)existingStacks.get(s)).getItem(), 1, true);
                }
                return SlotDefinition.inaccesible();
            });
            if (!definitions.get(slot).isAccessible()) continue;
            boolean uncompressibledFromNext = definitions.containsKey(slot - 1) && definitions.get(slot - 1).isAccessible() && definitions.get(slot).prevSlotMultiplier() > 1;
            boolean compressibleFromPrevious = definitions.containsKey(slot + 1) && definitions.get(slot + 1).isAccessible() && definitions.get(slot + 1).prevSlotMultiplier() > 1;
            definitions.get(slot).setCompressible(uncompressibledFromNext || compressibleFromPrevious);
        }
    }

    private void clearCollections() {
        this.slotDefinitions.clear();
        this.calculatedStacks.clear();
        this.parent.onFilterItemsChanged();
    }

    private Optional<RecipeHelper.CompactingShape> getCompressionShape(Item item) {
        Set compactingShapes = RecipeHelper.getItemCompactingShapes((Item)item);
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE)) {
            Item compressedItem = RecipeHelper.getCompactingResult((Item)item, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.THREE_BY_THREE).getResult().getItem();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) : Optional.empty();
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            Item compressedItem = RecipeHelper.getCompactingResult((Item)item, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.TWO_BY_TWO).getResult().getItem();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) : Optional.empty();
        }
        return Optional.empty();
    }

    private void addPreviousItems(Map<Integer, SlotDefinition> slotDefinitions, int firstFilledSlot, Item firstFilledItem) {
        Item currentItem = firstFilledItem;
        for (int slot = firstFilledSlot + 1; slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            RecipeHelper.UncompactingResult uncompactingResult = RecipeHelper.getUncompactingResult((Item)currentItem);
            if (uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.NONE) {
                Optional<RecipeHelper.UncompactingResult> decompressionResult = this.getDecompressionResultFromConfig(currentItem);
                if (decompressionResult.isEmpty()) break;
                uncompactingResult = decompressionResult.get();
            }
            slotDefinitions.put(slot, new SlotDefinition(uncompactingResult.getResult(), uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE ? 4 : 9, true));
            currentItem = uncompactingResult.getResult();
        }
    }

    Optional<RecipeHelper.UncompactingResult> getDecompressionResultFromConfig(Item currentItem) {
        return Config.SERVER.compressionUpgrade.getDecompressionResult(currentItem);
    }

    private Map<Integer, ItemStack> getExistingStacks() {
        LinkedHashMap<Integer, ItemStack> existingStacks = new LinkedHashMap<Integer, ItemStack>();
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            ItemStack slotStack = this.parent.getSlotStack(slot);
            if (slotStack.isEmpty()) continue;
            existingStacks.put(slot, slotStack);
        }
        if (existingStacks.isEmpty()) {
            MemorySettingsCategory memorySettings = this.getMemorySettings.get();
            for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
                int finalSlot = slot;
                memorySettings.getSlotFilterStack(slot, true).ifPresent(stack -> existingStacks.put(finalSlot, (ItemStack)stack));
            }
        }
        return existingStacks;
    }

    public int getSlotLimit(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).slotLimit() : this.parent.getBaseSlotLimit();
    }

    public int getStackLimit(int slot, ItemStack stack) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return this.parent.getBaseStackLimit(stack);
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return this.getStackLimit(slotDefinition);
    }

    private int getStackLimit(SlotDefinition slotDefinition) {
        if (!slotDefinition.isAccessible()) {
            return 0;
        }
        return slotDefinition.slotLimit();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, ItemStack::getMaxStackSize);
    }

    private ItemStack extractItem(int slot, int amount, boolean simulate, ToIntFunction<ItemStack> getLimit) {
        if (!this.slotDefinitions.containsKey(slot) || !this.slotDefinitions.get(slot).isAccessible()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(this.calculatedStacks.get(slot).getCount(), amount);
        if (toExtract > 0) {
            ItemStack result;
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            ItemStack slotStack = this.parent.getSlotStack(slot);
            toExtract = Math.min(toExtract, getLimit.applyAsInt(slotStack));
            ItemStack itemStack = result = slotDefinition.isCompressible() ? new ItemStack((ItemLike)slotDefinition.item(), toExtract) : ItemHandlerHelper.copyStackWithSize((ItemStack)slotStack, (int)toExtract);
            if (!simulate) {
                if (slotDefinition.isCompressible()) {
                    this.extractFromCalculated(slot, toExtract);
                    this.extractFromInternal(slot, toExtract);
                } else {
                    slotStack.shrink(toExtract);
                    this.parent.setSlotStack(slot, slotStack);
                    this.calculatedStacks.put(slot, slotStack.copy());
                }
                this.removeDefinitionsIfEmpty(slot);
            }
            return result;
        }
        return ItemStack.EMPTY;
    }

    private void removeDefinitionsIfEmpty(int slotTriggeringChange) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots(); ++slot) {
            if (this.parent.getSlotStack(slot).isEmpty() && !this.getMemorySettings.get().getSlotFilterStack(slot, false).isPresent()) continue;
            return;
        }
        this.clearCollections();
        this.parent.triggerOnChangeListeners(slotTriggeringChange);
    }

    private void extractFromInternal(int slotToStartFrom, int amountToExtract) {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        int decompressedAmountToInsert = 0;
        int totalMultiplier = 1;
        while (amountToExtract > 0) {
            ItemStack slotStack = this.parent.getSlotStack(slotToStartFrom);
            if (totalMultiplier == 1) {
                int toRemove = Math.min(amountToExtract, slotStack.getCount());
                toUpdate.put(slotToStartFrom, slotStack.getCount() - toRemove);
                amountToExtract -= toRemove;
            } else {
                int ceiledAmount = (int)Math.ceil((double)amountToExtract / (double)totalMultiplier);
                int toRemove = Math.min(ceiledAmount, slotStack.getCount());
                toUpdate.put(slotToStartFrom, slotStack.getCount() - toRemove);
                int totalToRemove = toRemove * totalMultiplier;
                if (totalToRemove > amountToExtract) {
                    decompressedAmountToInsert = totalToRemove - amountToExtract;
                    break;
                }
                amountToExtract -= totalToRemove;
            }
            totalMultiplier *= this.getPrevSlotMultiplier(slotToStartFrom);
            --slotToStartFrom;
        }
        while (decompressedAmountToInsert > 0) {
            int toInsert;
            if ((toInsert = decompressedAmountToInsert / (totalMultiplier /= this.getPrevSlotMultiplier(++slotToStartFrom))) <= 0) continue;
            toUpdate.put(slotToStartFrom, toUpdate.getOrDefault(slotToStartFrom, 0) + toInsert);
            decompressedAmountToInsert -= toInsert * totalMultiplier;
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private int getPrevSlotMultiplier(int slot) {
        return this.slotDefinitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier;
    }

    private void updateInternalStacksWithCounts(Map<Integer, Integer> toUpdate) {
        toUpdate.forEach((s, count) -> {
            ItemStack slotStack = this.parent.getSlotStack(s.intValue());
            if (slotStack.getCount() != count.intValue()) {
                if (count == 0) {
                    this.parent.setSlotStack(s.intValue(), ItemStack.EMPTY);
                } else if (slotStack.isEmpty()) {
                    this.parent.setSlotStack(s.intValue(), new ItemStack((ItemLike)this.slotDefinitions.get(s).item(), count.intValue()));
                } else {
                    slotStack.setCount(count.intValue());
                    this.parent.setSlotStack(s.intValue(), slotStack);
                }
            }
        });
    }

    private void extractFromCalculated(int slot, int extractCount) {
        this.extractFromCalculatedThisAndPreviousStacks(extractCount, slot);
        this.extractFromCalculatedThisAndStacksAfter(extractCount, slot + 1);
    }

    private void extractFromCalculatedThisAndPreviousStacks(int extractCount, int slotCalculated) {
        int countBeforeChange = -1;
        int multiplier = 1;
        while (extractCount != 0 && this.calculatedStacks.containsKey(slotCalculated)) {
            ItemStack calculatedStack = this.calculatedStacks.get(slotCalculated);
            if (countBeforeChange > 0 && countBeforeChange / multiplier > calculatedStack.getCount() && (extractCount = calculatedStack.getCount() - (countBeforeChange - extractCount * multiplier) / multiplier) <= 0) break;
            countBeforeChange = calculatedStack.getCount();
            int toSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countBeforeChange - extractCount, slotCalculated, calculatedStack);
            calculatedStack.setCount(toSet);
            this.calculatedStacks.put(slotCalculated, calculatedStack);
            multiplier = this.getPrevSlotMultiplier(slotCalculated);
            extractCount = countBeforeChange / multiplier - calculatedStack.getCount() / multiplier;
            --slotCalculated;
        }
    }

    private int getCountChangeLeavingSpaceBeforeMaxInt(int countCalculated, int slotCalculated, ItemStack calculatedStack) {
        boolean hasPrevious;
        int toSet = countCalculated;
        int prevSlot = slotCalculated - 1;
        SlotDefinition prevSlotDefinition = this.slotDefinitions.get(prevSlot);
        boolean bl = hasPrevious = prevSlotDefinition != null && prevSlotDefinition.isAccessible();
        if (countCalculated > 0 && Integer.MAX_VALUE - countCalculated < calculatedStack.getMaxStackSize() && hasPrevious) {
            boolean prevSlotFull = this.getSlotLimit(prevSlot) == this.calculatedStacks.get(prevSlot).getCount();
            int buffer = prevSlotFull ? this.getStackLimit(slotCalculated, calculatedStack) - countCalculated : calculatedStack.getMaxStackSize();
            toSet = Integer.MAX_VALUE - buffer;
        }
        return toSet;
    }

    private void extractFromCalculatedThisAndStacksAfter(int extractCount, int slot) {
        while (slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots() && this.slotDefinitions.get(slot).isAccessible()) {
            ItemStack calculatedStack = this.calculatedStacks.get(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            int countSet = calculatedStack.getCount() - (extractCount *= multiplier);
            countSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countSet, slot, calculatedStack);
            calculatedStack.setCount(countSet);
            this.calculatedStacks.put(slot, calculatedStack);
            ++slot;
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, TriFunction<Integer, ItemStack, Boolean, ItemStack> insertSuper) {
        return this.insertItem(slot, stack, simulate);
    }

    private ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canNotBeInserted(slot, stack)) {
            return stack;
        }
        Map<Integer, SlotDefinition> definitions = this.slotDefinitions;
        if (definitions.isEmpty()) {
            definitions = this.getSlotDefinitions(stack.getItem(), slot, Map.of());
        }
        int limit = this.getStackLimit(definitions.get(slot));
        int currentCalculatedCount = this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).getCount() : 0;
        int inserted = Math.min(Math.max(this.parent.getBaseStackLimit(stack) - this.parent.getSlotStack(slot).getCount(), limit - currentCalculatedCount), stack.getCount());
        if (inserted == 0) {
            return stack;
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - inserted));
        if (simulate) {
            return result;
        }
        if (!this.slotDefinitions.containsKey(slot)) {
            this.setSlotDefinitions(definitions, false);
            this.compactInternalSlots();
            this.updateCalculatedStacks();
        }
        if (this.slotDefinitions.get(slot).isCompressible()) {
            this.insertIntoInternalAndCalculated(slot, inserted);
        } else if (inserted > 0) {
            this.calculatedStacks.compute(slot, (s, st) -> {
                if (st == null || st.isEmpty()) {
                    ItemStack copy = stack.copy();
                    copy.setCount(inserted);
                    return copy;
                }
                st.grow(inserted);
                return st;
            });
            ItemStack slotStack = this.parent.getSlotStack(slot);
            if (slotStack.isEmpty()) {
                ItemStack copy = stack.copy();
                copy.setCount(inserted);
                this.parent.setSlotStack(slot, copy);
            } else {
                slotStack.grow(inserted);
                this.parent.setSlotStack(slot, slotStack);
            }
        }
        return result;
    }

    private boolean canNotBeInserted(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        if (!this.slotDefinitions.containsKey(slot)) {
            return false;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return !slotDefinition.isAccessible() || slotDefinition.item() != stack.getItem();
    }

    private void insertIntoInternalAndCalculated(int slotToStartFrom, long amountToInsert) {
        LinkedHashMap<Integer, Integer> toUpdate = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> calculatedAdditions = new LinkedHashMap<Integer, Integer>();
        int totalMultiplier = 1;
        int slot = slotToStartFrom;
        long amountToSet = amountToInsert + (long)this.parent.getSlotStack(slot).getCount();
        while (amountToSet / ((long)totalMultiplier * (long)this.getPrevSlotMultiplier(slot)) > 0L && this.slotDefinitions.containsKey(slot - 1) && this.slotDefinitions.get(slot - 1).isAccessible()) {
            amountToSet += (long)this.parent.getSlotStack(--slot).getCount() * (long)(totalMultiplier *= this.getPrevSlotMultiplier(slot));
        }
        long calculatedAddition = 0L;
        while (slot <= slotToStartFrom) {
            calculatedAddition *= (long)this.getPrevSlotMultiplier(slot);
            ItemStack slotStack = this.parent.getSlotStack(slot);
            int toSet = (int)Math.min(amountToSet / (long)totalMultiplier, (long)this.parent.getBaseStackLimit(slotStack));
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition += (long)(toSet - slotStack.getCount()), Integer.MAX_VALUE));
            if (toSet > 0) {
                toUpdate.put(slot, toSet);
                amountToSet -= (long)toSet * (long)totalMultiplier;
            } else {
                toUpdate.put(slot, 0);
            }
            if (amountToSet != 0L) {
                totalMultiplier /= this.getPrevSlotMultiplier(slot + 1);
            }
            ++slot;
        }
        while (slot < this.slotRange.firstSlot() + this.slotRange.numberOfSlots() && this.slotDefinitions.containsKey(slot)) {
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition *= (long)this.getPrevSlotMultiplier(slot), Integer.MAX_VALUE));
            ++slot;
        }
        this.updateInternalStacksWithCounts(toUpdate);
        calculatedAdditions.forEach(this::addToCalculatedStack);
    }

    private void addToCalculatedStack(int slot, int countToAdd) {
        if (!this.calculatedStacks.containsKey(slot) || this.calculatedStacks.get(slot).isEmpty()) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            this.calculatedStacks.put(slot, new ItemStack((ItemLike)slotDefinition.item(), countToAdd));
            return;
        }
        ItemStack currentCalculated = this.calculatedStacks.get(slot);
        int totalCalculated = Integer.MAX_VALUE - countToAdd < currentCalculated.getCount() ? Integer.MAX_VALUE : currentCalculated.getCount() + countToAdd;
        int previousSlot = slot - 1;
        if (totalCalculated != Integer.MAX_VALUE || !this.slotDefinitions.containsKey(previousSlot)) {
            currentCalculated.setCount(totalCalculated);
            return;
        }
        ItemStack previousInternalStack = this.parent.getSlotStack(previousSlot);
        boolean isPreviousFull = previousInternalStack.getCount() >= this.parent.getBaseStackLimit(previousInternalStack);
        int internalLimit = this.parent.getBaseStackLimit(currentCalculated);
        int internalCount = this.parent.getSlotStack(slot).getCount();
        int maxStackSize = previousInternalStack.getMaxStackSize();
        int spaceBeforeMaxInt = isPreviousFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize;
        currentCalculated.setCount(Integer.MAX_VALUE - spaceBeforeMaxInt);
    }

    public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotSuper) {
        int currentCount;
        int n = currentCount = this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).getCount() : 0;
        if (currentCount < stack.getCount()) {
            this.insertItem(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - currentCount)), false);
        } else if (currentCount > stack.getCount()) {
            this.extractItem(slot, currentCount - stack.getCount(), false, s -> Integer.MAX_VALUE);
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return true;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return slotDefinition.isAccessible() && slotDefinition.item() == stack.getItem();
    }

    public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
        return this.slotDefinitions.containsKey(slot) && this.slotDefinitions.get(slot).isAccessible() && this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot) : ItemStack.EMPTY;
    }

    public boolean isSlotAccessible(int slot) {
        return !this.slotDefinitions.containsKey(slot) || this.slotDefinitions.get(slot).isAccessible();
    }

    public int getSlots() {
        return this.slotRange.numberOfSlots();
    }

    public String getName() {
        return NAME;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon(int slot) {
        return EMPTY_COMPRESSION_SLOT;
    }

    public Item getFilterItem(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).item() : Items.AIR;
    }

    public void onSlotLimitChange() {
        this.updateSlotLimits(this.slotDefinitions);
    }

    public Set<Integer> getNoSortSlots() {
        return IntStream.rangeClosed(this.slotRange.firstSlot(), this.slotRange.firstSlot() + this.slotRange.numberOfSlots() - 1).boxed().collect(Collectors.toSet());
    }

    public void onSlotFilterChanged(int slot) {
        this.calculateStacks(false);
    }

    public boolean isFilterItem(Item item) {
        for (SlotDefinition slotDefinition : this.slotDefinitions.values()) {
            if (slotDefinition.item() != item) continue;
            return true;
        }
        return false;
    }

    public Map<Item, Set<Integer>> getFilterItems() {
        HashMap<Item, Set<Integer>> filterItems = new HashMap<Item, Set<Integer>>();
        for (Map.Entry<Integer, SlotDefinition> entry : this.slotDefinitions.entrySet()) {
            SlotDefinition slotDefinition = entry.getValue();
            if (!slotDefinition.isAccessible()) continue;
            filterItems.computeIfAbsent(slotDefinition.item(), k -> new HashSet()).add(entry.getKey());
        }
        return filterItems;
    }

    private static final class SlotDefinition {
        private final Item item;
        private final int prevSlotMultiplier;
        private int slotLimit;
        private final boolean isAccessible;
        private boolean isCompressible = false;

        private SlotDefinition(Item item, int prevSlotMultiplier, int slotLimit, boolean isAccessible) {
            this.item = item;
            this.prevSlotMultiplier = prevSlotMultiplier;
            this.slotLimit = slotLimit;
            this.isAccessible = isAccessible;
        }

        public static SlotDefinition inaccesible() {
            return new SlotDefinition(Items.AIR, 0, 0, false);
        }

        public SlotDefinition(Item item, int prevSlotMultiplier, boolean isAccessible) {
            this(item, prevSlotMultiplier, -1, isAccessible);
        }

        public void setSlotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
        }

        public void setCompressible(boolean compressible) {
            this.isCompressible = compressible;
        }

        public Item item() {
            return this.item;
        }

        public int prevSlotMultiplier() {
            return this.prevSlotMultiplier;
        }

        public int slotLimit() {
            return this.slotLimit;
        }

        public boolean isAccessible() {
            return this.isAccessible;
        }

        public boolean isCompressible() {
            return this.isCompressible;
        }
    }
}

