/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartRegistry;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.compression.CompressionInventoryPart;

public class CompressionUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType(Wrapper::new);
    private static final String FIRST_INVENTORY_SLOT_TAG = "firstInventorySlot";
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(CompactingUpgradeItem.class::isInstance, 0, StorageTranslationHelper.INSTANCE.translError("add.compacting_exists", new Object[0])));

    public CompressionUpgradeItem() {
        super((IUpgradeCountLimitConfig)Config.SERVER.maxUpgradesPerStorage);
        InventoryPartRegistry.registerFactory((String)"compression", CompressionInventoryPart::new);
    }

    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    private UpgradeSlotChangeResult checkCompressionSpace(IStorageWrapper storageWrapper) {
        Optional slotRange = storageWrapper.getInventoryHandler().getInventoryPartitioner().getFirstSpace(((Integer)Config.SERVER.compressionUpgrade.maxNumberOfSlots.get()).intValue());
        return slotRange.map(range -> this.canUseForCompression(storageWrapper, (InventoryPartitioner.SlotRange)range)).orElseGet(() -> new UpgradeSlotChangeResult.Fail(StorageTranslationHelper.INSTANCE.translError("add.compression_no_space", new Object[0]), Collections.emptySet(), Collections.emptySet(), Collections.emptySet()));
    }

    public UpgradeSlotChangeResult checkExtraInsertConditions(ItemStack upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        return this.checkCompressionSpace(storageWrapper);
    }

    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    private UpgradeSlotChangeResult canUseForCompression(IStorageWrapper storageWrapper, InventoryPartitioner.SlotRange slotRange) {
        boolean allRemainingSlotsMustBeEmpty = false;
        Item nextItemToMatch = Items.AIR;
        LinkedHashSet<Integer> errorSlots = new LinkedHashSet<Integer>();
        InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
        MemorySettingsCategory memorySettingsCategory = (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        for (int slot = slotRange.firstSlot() + slotRange.numberOfSlots() - 1; slot >= slotRange.firstSlot(); --slot) {
            boolean hasSlotBeforeThisOne;
            ItemStack slotStack = inventoryHandler.getSlotStack(slot);
            Item item = !slotStack.isEmpty() ? slotStack.getItem() : memorySettingsCategory.getSlotFilterStack(slot, false).map(ItemStack::getItem).orElse(Items.AIR);
            if (item == Items.AIR) continue;
            if (allRemainingSlotsMustBeEmpty) {
                errorSlots.add(slot);
                continue;
            }
            if (nextItemToMatch != Items.AIR && nextItemToMatch != item) {
                errorSlots.add(slot);
                break;
            }
            boolean bl = hasSlotBeforeThisOne = slot - 1 >= slotRange.firstSlot();
            if (!hasSlotBeforeThisOne) continue;
            RecipeHelper.CompactingShape compactingShape = RecipeHelper.getItemCompactingShapes((Item)item).stream().filter(RecipeHelper.CompactingShape::isUncraftable).findFirst().orElse(RecipeHelper.CompactingShape.NONE);
            if (compactingShape == RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE || compactingShape == RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) {
                nextItemToMatch = RecipeHelper.getCompactingResult((Item)item, (RecipeHelper.CompactingShape)compactingShape).getResult().getItem();
                continue;
            }
            allRemainingSlotsMustBeEmpty = true;
        }
        return !errorSlots.isEmpty() ? new UpgradeSlotChangeResult.Fail(StorageTranslationHelper.INSTANCE.translError("add.compression_incompatible_items", new Object[0]), Set.of(), errorSlots, Set.of()) : new UpgradeSlotChangeResult.Success();
    }

    public ItemStack getCleanedUpgradeStack(ItemStack upgradeStack) {
        upgradeStack.removeTagKey(FIRST_INVENTORY_SLOT_TAG);
        return upgradeStack;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, CompressionUpgradeItem> {
        public void onAdded() {
            this.upgrade.removeTagKey(CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG);
            InventoryPartitioner inventoryPartitioner = this.storageWrapper.getInventoryHandler().getInventoryPartitioner();
            inventoryPartitioner.getFirstSpace(((Integer)Config.SERVER.compressionUpgrade.maxNumberOfSlots.get()).intValue()).ifPresent(slotRange -> {
                this.setFirstInventorySlot(slotRange.firstSlot());
                inventoryPartitioner.addInventoryPart(slotRange.firstSlot(), slotRange.numberOfSlots(), (IInventoryPartHandler)new CompressionInventoryPart(this.storageWrapper.getInventoryHandler(), (InventoryPartitioner.SlotRange)slotRange, () -> (MemorySettingsCategory)this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)));
            });
            ((ItemDisplaySettingsCategory)this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
        }

        private void setFirstInventorySlot(int firstInventorySlot) {
            this.upgrade.getOrCreateTag().putInt(CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG, firstInventorySlot);
            this.save();
        }

        public boolean canBeDisabled() {
            return false;
        }

        public boolean hideSettingsTab() {
            return true;
        }

        public void onBeforeRemoved() {
            super.onBeforeRemoved();
            this.storageWrapper.getInventoryHandler().getInventoryPartitioner().removeInventoryPart(this.getFirstInventorySlot());
            this.save();
        }

        private int getFirstInventorySlot() {
            return NBTHelper.getInt((ItemStack)this.upgrade, (String)CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG).orElse(-1);
        }

        protected Wrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }
    }
}

