/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private Set<Direction> pullDirections = new LinkedHashSet<Direction>();
    private Set<Direction> pushDirections = new LinkedHashSet<Direction>();
    private boolean directionsInitialized = false;
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> handlerCache = new EnumMap<Direction, BlockCapabilityCache<IItemHandler, Direction>>(Direction.class);
    private final ContentsFilterLogic inputFilterLogic;
    private final ContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "inputFilter");
        this.outputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), "outputFilter");
        this.deserialize();
    }

    public void tick(@Nullable LivingEntity entity, Level level, BlockPos pos) {
        this.initDirections(level, pos);
        if (this.coolDownTime > level.getGameTime()) {
            return;
        }
        for (Direction pushDirection : this.pushDirections) {
            if (this.runOnItemHandler(level, pos, pushDirection, this::pushItems)) break;
        }
        for (Direction pullDirection : this.pullDirections) {
            if (this.runOnItemHandler(level, pos, pullDirection, this::pullItems)) break;
        }
        this.coolDownTime = level.getGameTime() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private void initDirections(Level level, BlockPos pos) {
        if (this.upgrade.hasTag() && (this.upgrade.getItem() != ModItems.HOPPER_UPGRADE.get() || this.directionsInitialized)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            Direction horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.pullDirections.clear();
            this.pushDirections.clear();
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
            this.directionsInitialized = true;
        }
    }

    private boolean pullItems(IItemHandler fromHandler) {
        return this.moveItems(fromHandler, (IItemHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic);
    }

    private boolean pushItems(IItemHandler toHandler) {
        return this.moveItems((IItemHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic);
    }

    private boolean moveItems(IItemHandler fromHandler, IItemHandler toHandler, FilterLogic filterLogic) {
        for (int slot = 0; slot < fromHandler.getSlots(); ++slot) {
            ItemStack remainder;
            ItemStack extractedStack;
            ItemStack slotStack = fromHandler.getStackInSlot(slot);
            if (slotStack.isEmpty() || !filterLogic.matchesFilter(slotStack) || (extractedStack = fromHandler.extractItem(slot, ((HopperUpgradeItem)this.upgradeItem).getMaxTransferStackSize(), true)).isEmpty() || (remainder = InventoryHelper.insertIntoInventory((ItemStack)extractedStack, (IItemHandler)toHandler, (boolean)true)).getCount() >= extractedStack.getCount()) continue;
            InventoryHelper.insertIntoInventory((ItemStack)fromHandler.extractItem(slot, extractedStack.getCount() - remainder.getCount(), false), (IItemHandler)toHandler, (boolean)false);
            return true;
        }
        return false;
    }

    @Override
    public void onNeighborChange(Level level, BlockPos pos, Direction direction) {
        if (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
    }

    public void updateCacheOnSide(Level level, BlockPos pos, Direction direction) {
        if (!(level.isLoaded(pos) && level.isLoaded(pos.relative(direction)) && level instanceof ServerLevel)) {
            this.handlerCache.remove(direction);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.handlerCache.computeIfAbsent(direction, k -> {
            BlockPos blockPos;
            WeakReference<HopperUpgradeWrapper> existRef = new WeakReference<HopperUpgradeWrapper>(this);
            BlockState storageState = level.getBlockState(pos);
            Block block = storageState.getBlock();
            if (block instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)block;
                blockPos = storageBlock.getNeighborPos(storageState, pos, direction);
            } else {
                blockPos = pos.relative(direction);
            }
            BlockPos offsetPos = blockPos;
            return BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)offsetPos, (Object)direction.getOpposite(), () -> existRef.get() != null, () -> this.updateCacheOnSide(level, pos, direction));
        });
    }

    private boolean runOnItemHandler(Level level, BlockPos pos, Direction direction, Predicate<IItemHandler> run) {
        if (!this.handlerCache.containsKey(direction)) {
            this.updateCacheOnSide(level, pos, direction);
        }
        if (this.handlerCache.get(direction) == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)this.handlerCache.get(direction).getCapability();
        return handler != null && run.test(handler);
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(Direction direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(Direction direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(Direction direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(Direction direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        NBTHelper.putList((CompoundTag)this.upgrade.getOrCreateTag(), (String)"pullDirections", this.pullDirections, d -> StringTag.valueOf((String)d.getSerializedName()));
        this.save();
    }

    private void serializePushDirections() {
        NBTHelper.putList((CompoundTag)this.upgrade.getOrCreateTag(), (String)"pushDirections", this.pushDirections, d -> StringTag.valueOf((String)d.getSerializedName()));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        if (this.upgrade.hasTag()) {
            this.pullDirections = NBTHelper.getCollection((CompoundTag)this.upgrade.getOrCreateTag(), (String)"pullDirections", (byte)8, t -> Optional.ofNullable(Direction.byName((String)t.getAsString())), HashSet::new).orElseGet(HashSet::new);
            this.pushDirections = NBTHelper.getCollection((CompoundTag)this.upgrade.getOrCreateTag(), (String)"pushDirections", (byte)8, t -> Optional.ofNullable(Direction.byName((String)t.getAsString())), HashSet::new).orElseGet(HashSet::new);
        }
    }

    public void initDirections(Direction pushDirection, Direction pullDirection) {
        this.setPushingTo(pushDirection, true);
        this.setPullingFrom(pullDirection, true);
    }
}

