/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.endermanoverhaul.common.tags.ModBlockTags;

public class CaveEnderman
extends BaseEnderman {
    public CaveEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.2187).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public static boolean checkSpawnRules(EntityType<CaveEnderman> enderman, ServerLevelAccessor serverLevel, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        if (!EndermanOverhaulConfig.spawnCaveEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        if (random.nextBoolean()) {
            return false;
        }
        if (serverLevel.getBiome(pos).is(Biomes.DEEP_DARK)) {
            return false;
        }
        return pos.getY() < serverLevel.getSeaLevel() && !serverLevel.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK) && Monster.checkMonsterSpawnRules(enderman, (ServerLevelAccessor)serverLevel, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new BaseEnderman.EndermanFreezeWhenLookedAt(this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new BaseEnderman.EndermanLeaveBlockGoal(this));
        this.goalSelector.addGoal(11, (Goal)new BaseEnderman.EndermanTakeBlockGoal(this));
        this.targetSelector.addGoal(1, (Goal)new BaseEnderman.EndermanLookForPlayerGoal(this, arg_0 -> ((CaveEnderman)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.DUST.get();
    }

    @Override
    public double getVisionRange() {
        return 24.0;
    }

    @Override
    public TagKey<Block> getCarriableBlockTag() {
        return ModBlockTags.CAVE_ENDERMAN_HOLDEABLE;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getTickCount() % 20 == 0 && this.isAlive()) {
            if (this.level().canSeeSky(this.blockPosition()) && this.level().isDay()) {
                this.hurt(this.damageSources().onFire(), 1.0f);
                this.teleportUnderBlock();
            } else if (this.level().getBrightness(LightLayer.BLOCK, this.blockPosition()) > 6) {
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleport()) continue;
                    this.setTarget(null);
                    return;
                }
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.CAVE_ENDERMAN_HURT.get();
    }

    private void teleportUnderBlock() {
        int range = 5;
        BlockPos.betweenClosedStream((int)Mth.floor((double)(this.getX() - (double)range)), (int)Mth.floor((double)(this.getY() - 5.0)), (int)Mth.floor((double)(this.getZ() - (double)range)), (int)Mth.floor((double)(this.getX() + (double)range)), (int)Mth.floor((double)this.getY()), (int)Mth.floor((double)(this.getZ() + (double)range))).filter(pos -> this.level().getBlockState(pos).isAir() && this.level().getBlockState(pos.above()).isAir() && !this.level().canSeeSky(pos)).findAny().ifPresent(pos -> {
            this.level().gameEvent(GameEvent.TELEPORT, this.position(), GameEvent.Context.of((Entity)this));
            this.teleportTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        });
        this.navigation.stop();
    }
}

