/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.pets.BasePetEnderman;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.EnderBullet;
import tech.alexnijjar.endermanoverhaul.common.registry.ModSoundEvents;

public class EndIslandsEnderman
extends BaseEnderman {
    private static final EntityDataAccessor<Boolean> DATA_POSSESSING = SynchedEntityData.defineId(EndIslandsEnderman.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public EndIslandsEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 42;
    }

    @NotNull
    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.21).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public static boolean checkMonsterSpawnRules(@NotNull EntityType<? extends Monster> type, ServerLevelAccessor level, @NotNull MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!EndermanOverhaulConfig.spawnEndIslandsEnderman || !EndermanOverhaulConfig.allowSpawning) {
            return false;
        }
        if (random.nextInt(20) != 0) {
            return false;
        }
        return BaseEnderman.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "possessing_controller", 5, state -> {
            if (!((Boolean)this.entityData.get(DATA_POSSESSING)).booleanValue()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.POSSESS);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new EndIslandsEndermanSummonProjectileGoal());
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_POSSESSING, (Object)false);
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @Override
    public boolean playRunAnimWhenAngry() {
        return false;
    }

    @Override
    public boolean canShake() {
        return false;
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean isAlwaysHostile() {
        return true;
    }

    @Override
    public boolean canTeleport() {
        return false;
    }

    @Override
    public double getVisionRange() {
        return 32.0;
    }

    @Override
    public boolean canPickupBlocks() {
        return false;
    }

    @Override
    public boolean speedUpWhenAngry() {
        return false;
    }

    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        if (this.getTarget() != null) {
            this.spawnProjectiles((Entity)this.getTarget());
        }
    }

    public void spawnProjectiles(Entity target) {
        for (int i = 0; i < 3; ++i) {
            EnderBullet bullet = new EnderBullet(this.level(), (LivingEntity)this, target, this.getDirection().getAxis());
            bullet.setPos(this.getX() + (this.random.nextDouble() - 0.5) * 2.0, this.getY() + 1.0 + (this.random.nextDouble() - 0.5) * 2.0, this.getZ() + (this.random.nextDouble() - 0.5) * 2.0);
            this.level().addFreshEntity((Entity)bullet);
        }
    }

    public boolean isPossessing() {
        return (Boolean)this.entityData.get(DATA_POSSESSING);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_DEATH.get();
    }

    @Override
    public SoundEvent getStareSound() {
        return (SoundEvent)ModSoundEvents.TALL_ENDERMAN_STARE.get();
    }

    public class EndIslandsEndermanSummonProjectileGoal
    extends Goal {
        protected int summonTicks;
        protected int nextAttackTickCount = 400;

        public boolean canUse() {
            LivingEntity target = EndIslandsEnderman.this.getTarget();
            if (target != null && target.isAlive()) {
                if (EndIslandsEnderman.this.isPossessing()) {
                    if (EndIslandsEnderman.this.tickCount + 500 >= this.nextAttackTickCount) {
                        EndIslandsEnderman.this.entityData.set(DATA_POSSESSING, (Object)false);
                        return true;
                    }
                    return false;
                }
                return EndIslandsEnderman.this.tickCount >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity target = EndIslandsEnderman.this.getTarget();
            return target != null && target.isAlive() && this.summonTicks > 0;
        }

        public void start() {
            EndIslandsEnderman.this.entityData.set(DATA_POSSESSING, (Object)true);
            this.nextAttackTickCount = EndIslandsEnderman.this.tickCount + 400;
            this.summonTicks = 28;
        }

        public void stop() {
            super.stop();
            LivingEntity target = EndIslandsEnderman.this.getTarget();
            if (target == null) {
                return;
            }
            EndIslandsEnderman.this.entityData.set(DATA_POSSESSING, (Object)false);
            EndIslandsEnderman.this.level().getEntities((Entity)EndIslandsEnderman.this, EndIslandsEnderman.this.getBoundingBox().inflate(15.0)).stream().filter(entity -> entity instanceof EnderMan).filter(entity -> !(entity instanceof BasePetEnderman)).forEach(entity -> ((EnderMan)entity).setTarget(target));
            EndIslandsEnderman.this.playSound(SoundEvents.SHULKER_SHOOT, 1.0f, 1.0f);
            EndIslandsEnderman.this.spawnProjectiles((Entity)target);
            EndIslandsEnderman.this.playSound(SoundEvents.EVOKER_CAST_SPELL, 1.0f, 1.0f);
        }

        public void tick() {
            --this.summonTicks;
            EndIslandsEnderman.this.navigation.stop();
        }
    }
}

