/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.base;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.items.HoodItem;

public abstract class BaseEnderman
extends EnderMan
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int lastStareSound = Integer.MIN_VALUE;

    public BaseEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.isCreepy() && this.playRunAnimWhenAngry() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "creepy_controller", 5, state -> {
            if (!this.canOpenMouth()) {
                return PlayState.STOP;
            }
            if (!this.isCreepy()) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ANGRY);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "hold_controller", 5, state -> {
            if (!this.canPickupBlocks()) {
                return PlayState.STOP;
            }
            if (this.getCarriedBlock() == null) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.HOLDING);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.getAttackAnim(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    public boolean canOpenMouth() {
        return true;
    }

    public boolean playRunAnimWhenAngry() {
        return true;
    }

    public boolean canShake() {
        return true;
    }

    public boolean playArmSwingAnimWhenAttacking() {
        return true;
    }

    public boolean isProvokedByEyeContact() {
        return true;
    }

    public boolean hasParticles() {
        return true;
    }

    @Nullable
    public ParticleOptions getCustomParticles() {
        return null;
    }

    public int getParticleCount() {
        return 2;
    }

    public int getParticleRate() {
        return 1;
    }

    public boolean canPickupBlocks() {
        return true;
    }

    public Vec3 getHeldBlockOffset() {
        return Vec3.ZERO;
    }

    public boolean isAlwaysHostile() {
        return false;
    }

    public boolean canTeleport() {
        return true;
    }

    public double getVisionRange() {
        return 256.0;
    }

    @Nullable
    public MobEffectInstance getHitEffect() {
        return null;
    }

    public TagKey<Block> getCarriableBlockTag() {
        return BlockTags.ENDERMAN_HOLDABLE;
    }

    @Nullable
    public MobEffectInstance getAreaEffect() {
        return null;
    }

    @Nullable
    public SoundEvent getAreaEffectSound() {
        return null;
    }

    public int getAreaEffectRange() {
        return 0;
    }

    public boolean hasLargeCreepyHitbox() {
        return false;
    }

    public SoundEvent getStareSound() {
        return SoundEvents.ENDERMAN_STARE;
    }

    public boolean speedUpWhenAngry() {
        return true;
    }

    public boolean canFloat() {
        return true;
    }

    public void tick() {
        super.tick();
        this.tickAreaEffect();
    }

    protected void tickAreaEffect() {
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getTickCount() % 20 != 0) {
            return;
        }
        MobEffectInstance areaEffect = this.getAreaEffect();
        if (areaEffect == null || this.getAreaEffectRange() == 0) {
            return;
        }
        LivingEntity target = this.getTarget();
        if (target == null) {
            return;
        }
        if (this.distanceToSqr((Entity)target) <= (double)(this.getAreaEffectRange() * this.getAreaEffectRange())) {
            if (this.getAreaEffectSound() != null && !target.hasEffect(areaEffect.getEffect())) {
                this.level().playSound(null, target.blockPosition(), this.getAreaEffectSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            target.addEffect(areaEffect);
        }
    }

    public void playStareSound() {
        if (this.tickCount >= this.lastStareSound + 400) {
            this.lastStareSound = this.tickCount;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), this.getStareSound(), this.getSoundSource(), 2.5f, 1.0f, false);
            }
        }
    }

    public void aiStep() {
        ParticleOptions customParticleType = this.getCustomParticles();
        if (this.hasParticles() && this.level().isClientSide() && customParticleType != null && this.getTickCount() % this.getParticleRate() == 0) {
            for (int i = 0; i < this.getParticleCount(); ++i) {
                this.level().addParticle(customParticleType, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (super.doHurtTarget(target)) {
            MobEffectInstance effect = this.getHitEffect();
            if (effect != null && target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                entity.addEffect(effect);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        if (!this.hasLargeCreepyHitbox() || !this.isCreepy()) {
            return super.getDimensions(pose);
        }
        return super.getDimensions(pose).scale(1.0f, 1.15f);
    }

    protected void registerGoals() {
        if (this.canFloat()) {
            this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        }
        this.goalSelector.addGoal(1, (Goal)new EndermanFreezeWhenLookedAt());
        if (this.isAlwaysHostile()) {
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, e -> !(e.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof HoodItem)));
        }
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new EndermanLeaveBlockGoal());
        this.goalSelector.addGoal(11, (Goal)new EndermanTakeBlockGoal());
        this.targetSelector.addGoal(1, (Goal)new EndermanLookForPlayerGoal(arg_0 -> ((BaseEnderman)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean isLookingAtMe(Player player) {
        if (!this.isProvokedByEyeContact()) {
            return false;
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof HoodItem) {
            return false;
        }
        ItemStack itemStack = (ItemStack)player.getInventory().armor.get(3);
        if (itemStack.is(Blocks.CARVED_PUMPKIN.asItem())) {
            return false;
        }
        Vec3 vec3 = player.getViewVector(1.0f).normalize();
        Vec3 vec32 = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double d = vec32.length();
        double e = vec3.dot(vec32 = vec32.normalize());
        return e > 1.0 - 0.025 / d && player.hasLineOfSight((Entity)this);
    }

    protected float getStandingEyeHeight(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 2.55f + (dimensions.height - 2.9f);
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        this.refreshDimensions();
    }

    protected boolean teleport() {
        if (!this.canTeleport()) {
            return false;
        }
        return super.teleport();
    }

    public boolean teleportTowards(Entity target) {
        if (!this.canTeleport()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX() - target.getX(), this.getY(0.5) - target.getEyeY(), this.getZ() - target.getZ());
        vec3 = vec3.normalize();
        double e = this.getX() + (this.random.nextDouble() - 0.5) * 8.0 - vec3.x * 16.0;
        double f = this.getY() + (double)(this.random.nextInt(16) - 8) - vec3.y * 16.0;
        double g = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0 - vec3.z * 16.0;
        return this.teleport(e, f, g);
    }

    public boolean teleport(double x, double y, double z) {
        if (!this.canTeleport()) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)mutableBlockPos).blocksMotion()) {
            mutableBlockPos.move(Direction.DOWN);
        }
        BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
        boolean bl = blockState.blocksMotion();
        boolean bl2 = blockState.getFluidState().is(FluidTags.WATER);
        if (bl && !bl2) {
            Vec3 vec3 = this.position();
            boolean bl3 = this.randomTeleport(x, y, z, true);
            if (bl3) {
                this.level().gameEvent(GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)this));
                if (!this.isSilent()) {
                    this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                    this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                }
            }
            return bl3;
        }
        return false;
    }

    public int getTickCount() {
        return this.tickCount + this.getId();
    }

    public class EndermanFreezeWhenLookedAt
    extends Goal {
        @Nullable
        private LivingEntity target;

        public EndermanFreezeWhenLookedAt() {
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            this.target = BaseEnderman.this.getTarget();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d = this.target.distanceToSqr((Entity)BaseEnderman.this);
            return !(d > BaseEnderman.this.getVisionRange()) && BaseEnderman.this.isLookingAtMe((Player)this.target);
        }

        public void start() {
            BaseEnderman.this.getNavigation().stop();
        }

        public void tick() {
            if (this.target == null) {
                return;
            }
            BaseEnderman.this.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }

    public class EndermanLeaveBlockGoal
    extends Goal {
        public boolean canUse() {
            if (BaseEnderman.this.getCarriedBlock() == null) {
                return false;
            }
            if (!BaseEnderman.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            return BaseEnderman.this.getRandom().nextInt(EndermanLeaveBlockGoal.reducedTickDelay((int)2000)) == 0;
        }

        public void tick() {
            RandomSource randomSource = BaseEnderman.this.getRandom();
            Level level = BaseEnderman.this.level();
            int i = Mth.floor((double)(BaseEnderman.this.getX() - 1.0 + randomSource.nextDouble() * 2.0));
            int j = Mth.floor((double)(BaseEnderman.this.getY() + randomSource.nextDouble() * 2.0));
            int k = Mth.floor((double)(BaseEnderman.this.getZ() - 1.0 + randomSource.nextDouble() * 2.0));
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = level.getBlockState(blockPos);
            BlockPos blockPos2 = blockPos.below();
            BlockState blockState2 = level.getBlockState(blockPos2);
            BlockState blockState3 = BaseEnderman.this.getCarriedBlock();
            if (blockState3 != null && this.canPlaceBlock(level, blockPos, blockState3 = Block.updateFromNeighbourShapes((BlockState)blockState3, (LevelAccessor)BaseEnderman.this.level(), (BlockPos)blockPos), blockState, blockState2, blockPos2)) {
                level.setBlock(blockPos, blockState3, 3);
                level.gameEvent(GameEvent.BLOCK_PLACE, blockPos, GameEvent.Context.of((Entity)BaseEnderman.this, (BlockState)blockState3));
                BaseEnderman.this.setCarriedBlock(null);
            }
        }

        private boolean canPlaceBlock(Level level, BlockPos destinationPos, BlockState carriedState, BlockState destinationState, BlockState belowDestinationState, BlockPos belowDestinationPos) {
            return destinationState.isAir() && !belowDestinationState.isAir() && !belowDestinationState.is(Blocks.BEDROCK) && belowDestinationState.isCollisionShapeFullBlock((BlockGetter)level, belowDestinationPos) && carriedState.canSurvive((LevelReader)level, destinationPos) && level.getEntities((Entity)BaseEnderman.this, AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)destinationPos))).isEmpty();
        }
    }

    public class EndermanTakeBlockGoal
    extends Goal {
        public boolean canUse() {
            if (!EndermanOverhaulConfig.allowPickingUpBlocks) {
                return false;
            }
            if (!BaseEnderman.this.canPickupBlocks()) {
                return false;
            }
            if (BaseEnderman.this.getCarriedBlock() != null) {
                return false;
            }
            if (!BaseEnderman.this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return false;
            }
            return BaseEnderman.this.getRandom().nextInt(EndermanTakeBlockGoal.reducedTickDelay((int)20)) == 0;
        }

        public void tick() {
            RandomSource randomSource = BaseEnderman.this.getRandom();
            Level level = BaseEnderman.this.level();
            int i = Mth.floor((double)(BaseEnderman.this.getX() - 2.0 + randomSource.nextDouble() * 4.0));
            int j = Mth.floor((double)(BaseEnderman.this.getY() + randomSource.nextDouble() * 3.0));
            int k = Mth.floor((double)(BaseEnderman.this.getZ() - 2.0 + randomSource.nextDouble() * 4.0));
            BlockPos blockPos = new BlockPos(i, j, k);
            BlockState blockState = level.getBlockState(blockPos);
            Vec3 vec3 = new Vec3((double)BaseEnderman.this.getBlockX() + 0.5, (double)j + 0.5, (double)BaseEnderman.this.getBlockZ() + 0.5);
            Vec3 vec32 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            BlockHitResult blockHitResult = level.clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)BaseEnderman.this));
            boolean bl = blockHitResult.getBlockPos().equals((Object)blockPos);
            if (blockState.is(BaseEnderman.this.getCarriableBlockTag()) && bl) {
                level.removeBlock(blockPos, false);
                level.gameEvent(GameEvent.BLOCK_DESTROY, blockPos, GameEvent.Context.of((Entity)BaseEnderman.this, (BlockState)blockState));
                BaseEnderman.this.setCarriedBlock(blockState.getBlock().defaultBlockState());
            }
        }
    }

    public class EndermanLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int teleportTime;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions;
        private final Predicate<LivingEntity> isAngerInducing;

        public EndermanLookForPlayerGoal(Predicate<LivingEntity> predicate) {
            super((Mob)BaseEnderman.this, Player.class, 10, false, false, predicate);
            this.continueAggroTargetConditions = TargetingConditions.forCombat().ignoreLineOfSight();
            this.isAngerInducing = livingEntity -> (BaseEnderman.this.isLookingAtMe((Player)livingEntity) || BaseEnderman.this.isAngryAt((LivingEntity)livingEntity)) && !BaseEnderman.this.hasIndirectPassenger((Entity)livingEntity);
            this.startAggroTargetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(this.isAngerInducing);
        }

        public boolean canUse() {
            this.pendingTarget = BaseEnderman.this.level().getNearestPlayer(this.startAggroTargetConditions, (LivingEntity)BaseEnderman.this);
            return this.pendingTarget != null;
        }

        public void start() {
            this.aggroTime = this.adjustedTickDelay(5);
            this.teleportTime = 0;
            BaseEnderman.this.setBeingStaredAt();
        }

        public void stop() {
            this.pendingTarget = null;
            super.stop();
        }

        public boolean canContinueToUse() {
            if (this.pendingTarget != null) {
                if (!this.isAngerInducing.test((LivingEntity)this.pendingTarget)) {
                    return false;
                }
                BaseEnderman.this.lookAt((Entity)this.pendingTarget, 10.0f, 10.0f);
                return true;
            }
            if (this.target != null) {
                if (BaseEnderman.this.hasIndirectPassenger((Entity)this.target)) {
                    return false;
                }
                if (this.continueAggroTargetConditions.test((LivingEntity)BaseEnderman.this, this.target)) {
                    return true;
                }
            }
            return super.canContinueToUse();
        }

        public void tick() {
            if (BaseEnderman.this.getTarget() == null) {
                super.setTarget(null);
            }
            if (this.pendingTarget != null) {
                if (--this.aggroTime <= 0) {
                    this.target = this.pendingTarget;
                    this.pendingTarget = null;
                    super.start();
                }
            } else {
                if (this.target != null && !BaseEnderman.this.isPassenger()) {
                    if (BaseEnderman.this.isLookingAtMe((Player)this.target)) {
                        if (this.target.distanceToSqr((Entity)BaseEnderman.this) < 16.0) {
                            BaseEnderman.this.teleport();
                        }
                        this.teleportTime = 0;
                    } else if (this.target.distanceToSqr((Entity)BaseEnderman.this) > BaseEnderman.this.getVisionRange() && this.teleportTime++ >= this.adjustedTickDelay(30) && BaseEnderman.this.teleportTowards((Entity)this.target)) {
                        this.teleportTime = 0;
                    }
                }
                super.tick();
            }
        }
    }
}

