/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.pets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModItems;
import tech.alexnijjar.endermanoverhaul.common.registry.ModParticleTypes;

public abstract class BasePetEnderman
extends BaseEnderman
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(BasePetEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private EndermanHurtByTargetGoal hurtByTargetGoal;

    public BasePetEnderman(EntityType<? extends BaseEnderman> entityType, Level level) {
        super(entityType, level);
    }

    public BasePetEnderman(EntityType<? extends BaseEnderman> entityType, Level level, Player owner) {
        super(entityType, level);
        this.setOwnerUUID(owner.getUUID());
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(this.isCreepy() ? ConstantAnimations.RUN : ConstantAnimations.WALK);
            } else {
                state.getController().setAnimation(ConstantAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 5, state -> {
            if (!this.playArmSwingAnimWhenAttacking()) {
                return PlayState.STOP;
            }
            if (this.getAttackAnim(state.getPartialTick()) == 0.0f) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(ConstantAnimations.ATTACK);
            return PlayState.CONTINUE;
        })});
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new EndermanFollowOwnerGoal(1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new EndermanOwnerHurtByTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new EndermanOwnerHurtTargetGoal());
        this.hurtByTargetGoal = new EndermanHurtByTargetGoal(new Class[0]);
        this.targetSelector.addGoal(3, (Goal)this.hurtByTargetGoal);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String string = compound.getString("Owner");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)Objects.requireNonNull(this.getServer()), (String)string);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean canBeLeashed(@NotNull Player player) {
        return !this.isLeashed();
    }

    @Override
    public void tick() {
        Player p;
        BasePetEnderman e;
        LivingEntity livingEntity;
        super.tick();
        if (!this.level().isClientSide() && (livingEntity = this.getTarget()) instanceof BasePetEnderman && Objects.equals((e = (BasePetEnderman)livingEntity).getOwnerUUID(), this.getOwnerUUID())) {
            this.setTarget(null);
            this.setLastHurtByMob(null);
        }
        if (!this.level().isClientSide() && (livingEntity = this.getTarget()) instanceof Player && (p = (Player)livingEntity).getUUID().equals(this.getOwnerUUID())) {
            this.setTarget(null);
            this.setLastHurtByMob(null);
        }
    }

    @Override
    @Nullable
    public ParticleOptions getCustomParticles() {
        return (ParticleOptions)ModParticleTypes.FRIENDERMAN.get();
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.isAlive() && this.getTickCount() % 2000 == 0) {
            this.heal(1.0f);
        }
    }

    public boolean wantsToAttack(LivingEntity target) {
        if (target instanceof Creeper) {
            return false;
        }
        if (target instanceof Ghast) {
            return false;
        }
        if (target instanceof BasePetEnderman) {
            BasePetEnderman otherPet = (BasePetEnderman)target;
            return !Objects.equals(otherPet.getOwnerUUID(), this.getOwnerUUID());
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            return !player.getUUID().equals(this.getOwnerUUID());
        }
        return true;
    }

    public void die(@NotNull DamageSource damageSource) {
        if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(damageSource);
    }

    @Override
    public boolean isProvokedByEyeContact() {
        return false;
    }

    @Override
    public boolean canOpenMouth() {
        return false;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.getUUID().equals(this.getOwnerUUID())) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide()) {
            CompoundTag entityTag = new CompoundTag();
            CompoundTag petTag = new CompoundTag();
            this.saveWithoutId(petTag);
            ItemStack pearl = ((Item)ModItems.ANCIENT_PEARL.get()).getDefaultInstance();
            entityTag.put("PetEntity", (Tag)petTag);
            entityTag.putString("PetType", BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()).getPath());
            pearl.setTag(entityTag);
            BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)pearl, (Vec3)this.position());
            this.playSound(SoundEvents.ENDERMAN_TELEPORT);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        for (int i = 0; i < this.getParticleCount(); ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public class EndermanFollowOwnerGoal
    extends Goal {
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public EndermanFollowOwnerGoal(double d, float f, float g, boolean bl) {
            this.level = BasePetEnderman.this.level();
            this.speedModifier = d;
            this.navigation = BasePetEnderman.this.getNavigation();
            this.startDistance = f;
            this.stopDistance = g;
            this.canFly = bl;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(BasePetEnderman.this.getNavigation() instanceof GroundPathNavigation) && !(BasePetEnderman.this.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean canUse() {
            LivingEntity livingEntity = BasePetEnderman.this.getOwner();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.isSpectator()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (BasePetEnderman.this.distanceToSqr((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.navigation.isDone()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(BasePetEnderman.this.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return BasePetEnderman.this.isPassenger() || BasePetEnderman.this.isLeashed();
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = BasePetEnderman.this.getPathfindingMalus(BlockPathTypes.WATER);
            BasePetEnderman.this.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
        }

        public void stop() {
            this.owner = null;
            this.navigation.stop();
            BasePetEnderman.this.setPathfindingMalus(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void tick() {
            BasePetEnderman.this.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)BasePetEnderman.this.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (BasePetEnderman.this.distanceToSqr((Entity)this.owner) >= Math.pow(20.0, 2.0)) {
                    this.teleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }

        private void teleportToOwner() {
            BlockPos blockPos = this.owner.blockPosition();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean teleported = this.maybeTeleportTo(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
                if (!teleported) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            BasePetEnderman.this.moveTo((double)x + 0.5, y, (double)z + 0.5, BasePetEnderman.this.getYRot(), BasePetEnderman.this.getXRot());
            this.navigation.stop();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            BlockPathTypes blockPathTypes = WalkNodeEvaluator.getBlockPathTypeStatic((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.mutable());
            if (blockPathTypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockState = this.level.getBlockState(pos.below());
            if (!this.canFly && blockState.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockPos = pos.subtract((Vec3i)BasePetEnderman.this.blockPosition());
            return this.level.noCollision((Entity)BasePetEnderman.this, BasePetEnderman.this.getBoundingBox().move(blockPos));
        }

        private int randomIntInclusive(int min, int max) {
            return BasePetEnderman.this.getRandom().nextInt(max - min + 1) + min;
        }
    }

    public class EndermanOwnerHurtByTargetGoal
    extends TargetGoal {
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public EndermanOwnerHurtByTargetGoal() {
            super((Mob)BasePetEnderman.this, false);
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity livingEntity = BasePetEnderman.this.getOwner();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurtBy = livingEntity.getLastHurtByMob();
            int i = livingEntity.getLastHurtByMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurtBy);
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurtBy);
            LivingEntity livingEntity = BasePetEnderman.this.getOwner();
            if (livingEntity != null) {
                this.timestamp = livingEntity.getLastHurtByMobTimestamp();
            }
            super.start();
        }
    }

    public class EndermanOwnerHurtTargetGoal
    extends TargetGoal {
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public EndermanOwnerHurtTargetGoal() {
            super((Mob)BasePetEnderman.this, false);
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity livingEntity = BasePetEnderman.this.getOwner();
            if (livingEntity == null) {
                return false;
            }
            this.ownerLastHurt = livingEntity.getLastHurtMob();
            int i = livingEntity.getLastHurtMobTimestamp();
            return i != this.timestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT) && BasePetEnderman.this.wantsToAttack(this.ownerLastHurt);
        }

        public void start() {
            this.mob.setTarget(this.ownerLastHurt);
            LivingEntity livingEntity = BasePetEnderman.this.getOwner();
            if (livingEntity != null) {
                this.timestamp = livingEntity.getLastHurtMobTimestamp();
            }
            super.start();
        }
    }

    public class EndermanHurtByTargetGoal
    extends TargetGoal {
        private static final TargetingConditions HURT_BY_TARGETING = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        private int timestamp;
        private final Class<?>[] toIgnoreDamage;

        public EndermanHurtByTargetGoal(Class<?> ... classes) {
            super((Mob)BasePetEnderman.this, true);
            this.toIgnoreDamage = classes;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean canUse() {
            int i = BasePetEnderman.this.getLastHurtByMobTimestamp();
            LivingEntity livingEntity = BasePetEnderman.this.getLastHurtByMob();
            if (i != this.timestamp && livingEntity != null) {
                if (livingEntity.getType() == EntityType.PLAYER && BasePetEnderman.this.level().getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                    return false;
                }
                if (!BasePetEnderman.this.wantsToAttack(livingEntity)) {
                    return false;
                }
                for (Class<?> clazz : this.toIgnoreDamage) {
                    if (!clazz.isAssignableFrom(livingEntity.getClass())) continue;
                    return false;
                }
                return this.canAttack(livingEntity, HURT_BY_TARGETING);
            }
            return false;
        }

        public void start() {
            BasePetEnderman.this.setTarget(BasePetEnderman.this.getLastHurtByMob());
            this.targetMob = BasePetEnderman.this.getTarget();
            this.timestamp = BasePetEnderman.this.getLastHurtByMobTimestamp();
            this.unseenMemoryTicks = 300;
            this.alertOthers();
            super.start();
        }

        public void notifyStart() {
            BasePetEnderman.this.setTarget(BasePetEnderman.this.getLastHurtByMob());
            this.targetMob = BasePetEnderman.this.getTarget();
            this.timestamp = BasePetEnderman.this.getLastHurtByMobTimestamp();
            this.unseenMemoryTicks = 300;
            super.start();
        }

        public void alertOthers() {
            Player p;
            UUID owner = BasePetEnderman.this.getOwnerUUID();
            if (owner == null) {
                return;
            }
            LivingEntity targetMob = BasePetEnderman.this.getTarget();
            if (targetMob instanceof Player && (p = (Player)targetMob).getUUID().equals(owner)) {
                return;
            }
            if (targetMob == null) {
                return;
            }
            AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)BasePetEnderman.this.position()).inflate(30.0);
            List pets = BasePetEnderman.this.level().getEntitiesOfClass(BasePetEnderman.class, aabb, EntitySelector.NO_SPECTATORS);
            pets.remove((Object)BasePetEnderman.this);
            List<BasePetEnderman> ownedPets = pets.stream().filter(pet -> owner.equals(pet.getOwnerUUID())).toList();
            if (ownedPets.size() <= 1) {
                return;
            }
            ArrayList<BasePetEnderman> targets = new ArrayList<BasePetEnderman>();
            if (targetMob instanceof BasePetEnderman) {
                BasePetEnderman target = (BasePetEnderman)targetMob;
                UUID targetOwner = target.getOwnerUUID();
                if (targetOwner == null) {
                    return;
                }
                targets.addAll(pets.stream().filter(pet -> targetOwner.equals(pet.getOwnerUUID())).toList());
                Player player = BasePetEnderman.this.level().getPlayerByUUID(targetOwner);
                if (player != null && player.distanceTo((Entity)BasePetEnderman.this) < 30.0f) {
                    targets.add((BasePetEnderman)player);
                }
                if (targets.isEmpty()) {
                    return;
                }
            } else if (targetMob instanceof Player) {
                Player player = (Player)targetMob;
                targets.add((BasePetEnderman)player);
                targets.addAll(pets.stream().filter(pet -> player.getUUID().equals(pet.getOwnerUUID())).toList());
            } else {
                AABB aabb2 = AABB.unitCubeFromLowerCorner((Vec3)BasePetEnderman.this.position()).inflate(20.0);
                targets.addAll(BasePetEnderman.this.level().getEntitiesOfClass(targetMob.getClass(), aabb2, EntitySelector.NO_SPECTATORS));
            }
            for (BasePetEnderman pet2 : ownedPets) {
                LivingEntity closestTarget = targets.stream().min(Comparator.comparingDouble(arg_0 -> ((BasePetEnderman)pet2).distanceToSqr(arg_0))).orElse(null);
                pet2.setLastHurtByMob(closestTarget);
                pet2.hurtByTargetGoal.notifyStart();
            }
        }
    }
}

