/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.items;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class HoodMaterial
implements ArmorMaterial {
    public static final ArmorMaterial MATERIAL = new HoodMaterial();
    private static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};
    private static final int[] PROTECTION_VALUES = new int[]{1, 4, 5, 2};

    public int getDurabilityForType(ArmorItem.Type type) {
        return BASE_DURABILITY[type.ordinal()] * 15;
    }

    public int getDefenseForType(ArmorItem.Type type) {
        return PROTECTION_VALUES[type.ordinal()];
    }

    public int getEnchantmentValue() {
        return 15;
    }

    @NotNull
    public SoundEvent getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_LEATHER;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER});
    }

    @NotNull
    public String getName() {
        return "chainmail";
    }

    public float getToughness() {
        return 0.0f;
    }

    public float getKnockbackResistance() {
        return 0.0f;
    }
}

