/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.mixins.common;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.alexnijjar.endermanoverhaul.common.tags.ModEntityTypeTags;

@Mixin(value={TheEndGatewayBlockEntity.class})
public abstract class TheEndGatewayBlockEntityMixin {
    @Shadow
    private boolean exactTeleport;
    @Shadow
    private BlockPos exitPortal;

    @Shadow
    private static BlockPos findExitPosition(Level level, BlockPos pos) {
        throw new AssertionError();
    }

    @Inject(method={"teleportEntity(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;)V"}, at={@At(target="Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;teleportEntity(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/entity/TheEndGatewayBlockEntity;)V", value="TAIL")})
    private static void endermanoverhaul$teleportEntity(Level level, BlockPos pos, BlockState state, Entity entity, TheEndGatewayBlockEntity blockEntity, CallbackInfo ci) {
        if (entity.getType().is(ModEntityTypeTags.ENDER_PEARLS)) {
            BlockPos blockPos;
            TheEndGatewayBlockEntity theEndGatewayBlockEntity;
            Entity owner = ((Projectile)entity).getOwner();
            if (owner instanceof ServerPlayer) {
                CriteriaTriggers.ENTER_BLOCK.trigger((ServerPlayer)owner, state);
            }
            if (!((theEndGatewayBlockEntity = blockEntity) instanceof TheEndGatewayBlockEntityMixin)) {
                return;
            }
            TheEndGatewayBlockEntityMixin gateway = (TheEndGatewayBlockEntityMixin)theEndGatewayBlockEntity;
            if (gateway.exitPortal == null) {
                return;
            }
            BlockPos blockPos2 = blockPos = gateway.exactTeleport ? gateway.exitPortal : TheEndGatewayBlockEntityMixin.findExitPosition(level, gateway.exitPortal);
            if (owner != null) {
                owner.setPortalCooldown();
                owner.teleportToWithTicket((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                entity.discard();
            } else {
                entity.setPortalCooldown();
                entity.teleportToWithTicket((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
            }
        }
    }
}

