/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betteroceanmonuments.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betteroceanmonuments.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WaterlogProcessor
extends StructureProcessor {
    public static final WaterlogProcessor INSTANCE = new WaterlogProcessor();
    public static final Codec<WaterlogProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        WorldGenRegion worldGenRegion;
        if (blockInfoGlobal.state().liquid() && blockInfoGlobal.pos().getY() < levelReader.getSeaLevel() && levelReader instanceof WorldGenRegion && (worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos())) && (blockInfoGlobal.pos().getX() % 16 == 0 || blockInfoGlobal.pos().getX() % 16 == 15 || blockInfoGlobal.pos().getZ() % 16 == 0 || blockInfoGlobal.pos().getZ() % 16 == 15)) {
            levelReader.getChunk(blockInfoGlobal.pos()).markPosForPostprocessing(blockInfoGlobal.pos());
        }
        if (blockInfoGlobal.state().hasProperty((Property)BlockStateProperties.WATERLOGGED) && blockInfoGlobal.pos().getY() < levelReader.getSeaLevel()) {
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), (BlockState)blockInfoGlobal.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.WATERLOG_PROCESSOR;
    }
}

