/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.just_enough_beacons.jei;

import com.cerbon.just_enough_beacons.jei.beacon_base_block.BeaconBaseBlockCategory;
import com.cerbon.just_enough_beacons.jei.beacon_base_block.BeaconBaseBlockRecipe;
import com.cerbon.just_enough_beacons.jei.beacon_payment.BeaconPaymentCategory;
import com.cerbon.just_enough_beacons.jei.beacon_payment.BeaconPaymentRecipe;
import com.cerbon.just_enough_beacons.jei.conduit_base_block.ConduitFrameBlockCategory;
import com.cerbon.just_enough_beacons.jei.conduit_base_block.ConduitFrameBlockRecipe;
import com.cerbon.just_enough_beacons.util.JEBRecipeTypes;
import java.util.ArrayList;
import java.util.stream.IntStream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEBJeiPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("just_enough_beacons", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new BeaconBaseBlockCategory(guiHelper), new BeaconPaymentCategory(guiHelper), new ConduitFrameBlockCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        BeaconBaseBlockRecipe.refresh();
        BeaconPaymentRecipe.refresh();
        ConduitFrameBlockRecipe.refresh();
        int beaconBaseBlockPages = (int)Math.ceil((double)BeaconBaseBlockRecipe.cache.size() / 28.0);
        int beaconPaymentPages = (int)Math.ceil((double)BeaconPaymentRecipe.cache.size() / 28.0);
        int conduitFrameBlockPages = (int)Math.ceil((double)ConduitFrameBlockRecipe.cache.size() / 28.0);
        ArrayList beaconBaseBlockRecipes = new ArrayList();
        ArrayList beaconPaymentRecipes = new ArrayList();
        ArrayList conduitFrameBlockRecipes = new ArrayList();
        IntStream.range(0, beaconBaseBlockPages).forEach(i -> beaconBaseBlockRecipes.add(new BeaconBaseBlockRecipe(i)));
        IntStream.range(0, beaconPaymentPages).forEach(i -> beaconPaymentRecipes.add(new BeaconPaymentRecipe(i)));
        IntStream.range(0, conduitFrameBlockPages).forEach(i -> conduitFrameBlockRecipes.add(new ConduitFrameBlockRecipe(i)));
        registration.addRecipes(JEBRecipeTypes.BEACON_BASE_BLOCK, beaconBaseBlockRecipes);
        registration.addRecipes(JEBRecipeTypes.BEACON_PAYMENT, beaconPaymentRecipes);
        registration.addRecipes(JEBRecipeTypes.CONDUIT_FRAME_BLOCK, conduitFrameBlockRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.BEACON), new RecipeType[]{JEBRecipeTypes.BEACON_BASE_BLOCK});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.BEACON), new RecipeType[]{JEBRecipeTypes.BEACON_PAYMENT});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.CONDUIT), new RecipeType[]{JEBRecipeTypes.CONDUIT_FRAME_BLOCK});
    }
}

