/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.just_enough_beacons.jei.conduit_base_block;

import com.cerbon.cerbons_api.api.static_utilities.MiscUtils;
import com.cerbon.just_enough_beacons.platform.JEBServices;
import com.cerbon.just_enough_beacons.util.JEBConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public record ConduitFrameBlockRecipe(int index) {
    public static List<ItemStack> cache = new ArrayList<ItemStack>();

    public List<ItemStack> getConduitFrameBlocksSublist() {
        return cache.subList(28 * this.index, Math.min(28 * this.index + 28, cache.size()));
    }

    public static void refresh() {
        cache.clear();
        cache = ConduitFrameBlockRecipe.getConduitFrameBlocks();
    }

    private static List<ItemStack> getConduitFrameBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> {
            if (MiscUtils.isModLoaded((String)"doubleslabs")) {
                try {
                    Class<?> dynamicSlabBlockClass = Class.forName("cjminecraft.doubleslabs.common.block.DynamicSlabBlock");
                    return !dynamicSlabBlockClass.isInstance(block) && JEBServices.PLATFORM_IS_CONDUIT_FRAME.isConduitFrame((Block)block);
                }
                catch (ClassNotFoundException e) {
                    JEBConstants.LOGGER.error("Couldn't find class DynamicSlabBlock", (Throwable)e);
                }
            }
            return JEBServices.PLATFORM_IS_CONDUIT_FRAME.isConduitFrame((Block)block);
        }).map(ItemStack::new).collect(Collectors.toList());
    }
}

