/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalForcer;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_MIN_CORNER = "ToMinCorner";
    private static final String TO_AXIS_1_SIZE = "ToAxis1Size";
    private static final String TO_AXIS_2_SIZE = "ToAxis2Size";

    public static BlockUtil.FoundRectangle findPortalAt(Player player, ResourceKey<Level> dim, BlockPos pos) {
        ServerLevel fromWorld;
        MinecraftServer server = player.level().getServer();
        if (server != null && (fromWorld = server.getLevel(dim)) != null) {
            PortalForcer portalForcer = fromWorld.getPortalForcer();
            return portalForcer.findPortalAround(pos, false, fromWorld.getWorldBorder()).orElse(null);
        }
        return null;
    }

    public static BlockUtil.FoundRectangle findRectangleFromReturnPortal(ServerLevel level, ReturnPortal returnPortal) {
        PortalForcer portalForcer = level.getPortalForcer();
        return portalForcer.findPortalAround(returnPortal.getRectangle().minCorner, false, level.getWorldBorder()).orElse(null);
    }

    public static ListTag getPlayerPortalList(Player player) {
        CompoundTag data = Balm.getHooks().getPersistentData(player);
        ListTag list = data.getList(RETURN_PORTAL_LIST, 10);
        data.put(RETURN_PORTAL_LIST, (Tag)list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(ServerPlayer player, ResourceKey<Level> fromDim, BlockPos fromPos) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        for (Tag entry : portalList) {
            BlockPos portalTrigger;
            CompoundTag portal = (CompoundTag)entry;
            ResourceKey entryFromDim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(portal.getString(FROM_DIM)));
            if (entryFromDim != fromDim || !((portalTrigger = BlockPos.of((long)portal.getLong(FROM_POS))).distSqr((Vec3i)fromPos) <= 16.0)) continue;
            UUID uid = portal.hasUUID(RETURN_PORTAL_UID) ? portal.getUUID(RETURN_PORTAL_UID) : UUID.randomUUID();
            BlockPos minCorner = BlockPos.of((long)portal.getLong(TO_MIN_CORNER));
            int axis1Size = portal.getInt(TO_AXIS_1_SIZE);
            int axis2Size = portal.getInt(TO_AXIS_2_SIZE);
            return new ReturnPortal(uid, new BlockUtil.FoundRectangle(minCorner, axis1Size, axis2Size));
        }
        return null;
    }

    public static void storeReturnPortal(ServerPlayer player, ResourceKey<Level> fromDim, BlockPos fromPos, BlockUtil.FoundRectangle toPortal) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        CompoundTag portalCompound = new CompoundTag();
        portalCompound.putUUID(RETURN_PORTAL_UID, UUID.randomUUID());
        portalCompound.putString(FROM_DIM, String.valueOf(fromDim.location()));
        portalCompound.putLong(FROM_POS, fromPos.asLong());
        portalCompound.putLong(TO_MIN_CORNER, toPortal.minCorner.asLong());
        portalCompound.putInt(TO_AXIS_1_SIZE, toPortal.axis1Size);
        portalCompound.putInt(TO_AXIS_2_SIZE, toPortal.axis2Size);
        portalList.add((Object)portalCompound);
    }

    public static void removeReturnPortal(ServerPlayer player, ReturnPortal portal) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Player)player);
        for (int i = 0; i < portalList.size(); ++i) {
            CompoundTag entry = (CompoundTag)portalList.get(i);
            if (!entry.hasUUID(RETURN_PORTAL_UID) || !entry.getUUID(RETURN_PORTAL_UID).equals(portal.getUid())) continue;
            portalList.remove(i);
            break;
        }
    }
}

