/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.client.render.highlight;

import com.glodblock.github.glodium.client.render.ColorData;
import com.glodblock.github.glodium.client.render.highlight.HighlightHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class HighlightRender
extends RenderType {
    public static final HighlightRender INSTANCE = new HighlightRender();
    private final RenderStateShard.LineStateShard LINE_3 = new RenderStateShard.LineStateShard(OptionalDouble.of(3.0));
    private final RenderType BLOCK_HIGHLIGHT_LINE = HighlightRender.create((String)"glodium_block_highlight_line", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)65536, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setLineState(this.LINE_3).setTransparencyState(RenderStateShard.TransparencyStateShard.GLINT_TRANSPARENCY).setTextureState(NO_TEXTURE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).setLightmapState(NO_LIGHTMAP).setWriteMaskState(COLOR_DEPTH_WRITE).setShaderState(RENDERTYPE_LINES_SHADER).createCompositeState(false));

    public static void hook(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            INSTANCE.tick(event.getPoseStack(), Minecraft.getInstance().renderBuffers().bufferSource(), event.getCamera());
        }
    }

    public void tick(PoseStack stack, MultiBufferSource.BufferSource multiBuf, Camera camera) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        this.invalidate();
        Collection<HighlightHandler.HighlightData> drawList = HighlightHandler.getBlockData();
        if (drawList.isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        for (HighlightHandler.HighlightData block : drawList) {
            if (!block.checkDim((ResourceKey<Level>)world.dimension()) || !block.allowRender()) continue;
            this.drawBlockOutline(block.box(), block.color(), stack, camera, (MultiBufferSource)multiBuf);
        }
        multiBuf.endBatch();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private void invalidate() {
        while (HighlightHandler.getFirst() != null) {
            HighlightHandler.HighlightData info = HighlightHandler.getFirst();
            if (System.currentTimeMillis() <= info.time()) break;
            HighlightHandler.expire();
        }
    }

    private void drawBlockOutline(AABB box, ColorData color, PoseStack stack, Camera camera, MultiBufferSource multiBuf) {
        float r = color.getRf();
        float g = color.getGf();
        float b = color.getBf();
        float a = color.getAf();
        if (camera.isInitialized()) {
            Vec3 vec3 = camera.getPosition().reverse();
            AABB aabb = box.move(vec3);
            Vec3 topRight = new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ);
            Vec3 bottomRight = new Vec3(aabb.maxX, aabb.minY, aabb.maxZ);
            Vec3 bottomLeft = new Vec3(aabb.minX, aabb.minY, aabb.maxZ);
            Vec3 topLeft = new Vec3(aabb.minX, aabb.maxY, aabb.maxZ);
            Vec3 topRight2 = new Vec3(aabb.maxX, aabb.maxY, aabb.minZ);
            Vec3 bottomRight2 = new Vec3(aabb.maxX, aabb.minY, aabb.minZ);
            Vec3 bottomLeft2 = new Vec3(aabb.minX, aabb.minY, aabb.minZ);
            Vec3 topLeft2 = new Vec3(aabb.minX, aabb.maxY, aabb.minZ);
            VertexConsumer buf = multiBuf.getBuffer(this.BLOCK_HIGHLIGHT_LINE);
            this.renderBox(buf, stack, topLeft, bottomLeft, topRight, bottomRight, r, g, b, a);
            this.renderBox(buf, stack, topLeft2, bottomLeft2, topRight2, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, topRight, topRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomRight, bottomRight2, r, g, b, a);
            this.renderLine(buf, stack, bottomLeft, bottomLeft2, r, g, b, a);
            this.renderLine(buf, stack, topLeft, topLeft2, r, g, b, a);
        }
    }

    private void renderBox(VertexConsumer buf, PoseStack stack, Vec3 topLeft, Vec3 bottomLeft, Vec3 topRight, Vec3 bottomRight, float r, float g, float b, float a) {
        this.renderLine(buf, stack, topLeft, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, topLeft, topRight, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, bottomLeft, r, g, b, a);
        this.renderLine(buf, stack, bottomRight, topRight, r, g, b, a);
    }

    private void renderLine(VertexConsumer buf, PoseStack pose, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        Matrix4f mat = pose.last().pose();
        Vec3 normal = from.subtract(to);
        buf.vertex(mat, (float)from.x, (float)from.y, (float)from.z).color(r, g, b, a).normal((float)normal.x, (float)normal.y, (float)normal.z).endVertex();
        buf.vertex(mat, (float)to.x, (float)to.y, (float)to.z).color(r, g, b, a).normal((float)normal.x, (float)normal.y, (float)normal.z).endVertex();
    }

    private HighlightRender() {
        super("", DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES, 0, false, false, () -> {}, () -> {});
    }
}

