/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.network;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.network.packet.IMessage;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class NetworkHandler {
    protected final Object2ObjectMap<ResourceLocation, Supplier<IMessage>> ID2Packet = new Object2ObjectOpenHashMap();
    protected final String modid;
    protected IPayloadRegistrar registrar;

    public NetworkHandler(String modid) {
        this.modid = modid;
    }

    public void onRegister(RegisterPayloadHandlerEvent event) {
        this.registrar = event.registrar(this.modid);
        this.initPackets();
    }

    protected void registerPacket(ResourceLocation id, Supplier<IMessage> factory) {
        if (this.ID2Packet.containsKey((Object)id)) {
            throw new IllegalArgumentException("Duplicate Packet Key: %s".formatted(id));
        }
        if (factory == null) {
            throw new IllegalArgumentException("Packet Constructor is null");
        }
        this.ID2Packet.put((Object)id, factory);
    }

    private void initPackets() {
        for (Map.Entry pair : this.ID2Packet.entrySet()) {
            ResourceLocation id = (ResourceLocation)pair.getKey();
            this.registrar.play(id, bytes -> this.fromBytes((FriendlyByteBuf)bytes, (Supplier)pair.getValue()), builder -> this.exec((IDirectionAwarePayloadHandlerBuilder)builder, (Supplier)pair.getValue()));
        }
    }

    private IMessage fromBytes(FriendlyByteBuf buf, Supplier<IMessage> factory) {
        IMessage packet = factory.get();
        packet.fromBytes(buf);
        return packet;
    }

    private <T extends IMessage> void exec(IDirectionAwarePayloadHandlerBuilder<T, IPlayPayloadHandler<T>> builder, Supplier<IMessage> factory) {
        IMessage packet = factory.get();
        if (packet.isClient()) {
            builder.client((p, c) -> c.workHandler().execute(() -> c.player().ifPresent(p::onMessage)));
        } else {
            builder.server((p, c) -> c.workHandler().execute(() -> {
                Object patt2728$temp = c.player().orElse(null);
                if (patt2728$temp instanceof ServerPlayer) {
                    ServerPlayer sp = patt2728$temp;
                    p.onMessage((Player)sp);
                }
            }));
        }
    }

    public void sendToAll(IMessage message) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{message});
    }

    public void sendTo(IMessage message, ServerPlayer player) {
        player.connection.send((CustomPacketPayload)message);
    }

    public void sendToAllAround(IMessage message, PacketDistributor.TargetPoint point) {
        MinecraftServer server = Glodium.INSTANCE.getServer();
        if (server != null) {
            PacketDistributor.NEAR.with((Object)point).send(new CustomPacketPayload[]{message});
        }
    }

    public void sendToServer(IMessage message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{message});
    }
}

