/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.network.packet.sync;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public final class ParaSerializer {
    public static void to(Object[] obj, FriendlyByteBuf buf) {
        buf.writeByte(obj.length);
        for (Object o : obj) {
            if (o instanceof Integer) {
                Integer i = (Integer)o;
                buf.writeByte(PT.INT.ordinal());
                buf.writeVarInt(i.intValue());
                continue;
            }
            if (o instanceof Long) {
                Long l = (Long)o;
                buf.writeByte(PT.LONG.ordinal());
                buf.writeVarLong(l.longValue());
                continue;
            }
            if (o instanceof Short) {
                Short s = (Short)o;
                buf.writeByte(PT.SHORT.ordinal());
                buf.writeShort((int)s.shortValue());
                continue;
            }
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                buf.writeByte(PT.BOOLEN.ordinal());
                buf.writeBoolean(b.booleanValue());
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                buf.writeByte(PT.STRING.ordinal());
                buf.writeUtf(s, 1024);
                continue;
            }
            if (o instanceof ItemStack) {
                ItemStack s = (ItemStack)o;
                buf.writeByte(PT.STACK.ordinal());
                buf.writeItem(s);
                continue;
            }
            if (o instanceof CompoundTag) {
                CompoundTag t = (CompoundTag)o;
                buf.writeByte(PT.NBT.ordinal());
                buf.writeNbt((Tag)t);
                continue;
            }
            throw new IllegalArgumentException("Args contains invalid type: " + o.getClass().getName());
        }
    }

    public static Object[] from(FriendlyByteBuf buf) {
        Object[] objs = new Object[buf.readByte()];
        block9: for (int i = 0; i < objs.length; ++i) {
            switch (PT.values()[buf.readByte()]) {
                case INT: {
                    objs[i] = buf.readVarInt();
                    continue block9;
                }
                case LONG: {
                    objs[i] = buf.readVarLong();
                    continue block9;
                }
                case SHORT: {
                    objs[i] = buf.readShort();
                    continue block9;
                }
                case BOOLEN: {
                    objs[i] = buf.readBoolean();
                    continue block9;
                }
                case STRING: {
                    objs[i] = buf.readUtf(1024);
                    continue block9;
                }
                case STACK: {
                    objs[i] = buf.readItem();
                    continue block9;
                }
                case NBT: {
                    objs[i] = buf.readNbt();
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Args contains unknown type.");
                }
            }
        }
        return objs;
    }

    private static enum PT {
        INT,
        LONG,
        SHORT,
        BOOLEN,
        STRING,
        STACK,
        NBT;

    }
}

