/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.registry;

import com.glodblock.github.glodium.Glodium;
import com.glodblock.github.glodium.util.GlodUtil;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class RegistryHandler {
    protected final String id;
    protected final List<Pair<String, Block>> blocks = new ArrayList<Pair<String, Block>>();
    protected final List<Pair<String, Item>> items = new ArrayList<Pair<String, Item>>();
    protected final List<Pair<String, BlockEntityType<?>>> tiles = new ArrayList();
    protected final List<Class<? extends BlockEntity>> tileClasses = new ArrayList<Class<? extends BlockEntity>>();
    protected final List<TileCapabilityMap<?, ?, ?>> tileCaps = new ArrayList();
    protected final List<ItemCapabilityMap<?, ?, ?>> itemCaps = new ArrayList();
    protected final Object2ReferenceMap<String, Function<Block, Item>> itemBlocks = new Object2ReferenceOpenHashMap();

    public RegistryHandler(String modid) {
        this.id = modid;
    }

    public void block(String name, Block block) {
        this.blocks.add((Pair<String, Block>)Pair.of((Object)name, (Object)block));
    }

    public void block(String name, Block block, Function<Block, Item> itemWrapper) {
        this.blocks.add((Pair<String, Block>)Pair.of((Object)name, (Object)block));
        this.itemBlocks.put((Object)name, itemWrapper);
    }

    public void item(String name, Item item) {
        this.items.add((Pair<String, Item>)Pair.of((Object)name, (Object)item));
    }

    public void tile(String name, BlockEntityType<?> type) {
        this.tiles.add(Pair.of((Object)name, type));
        this.tileClasses.add(GlodUtil.getTileClass(type));
    }

    public <T, C, X> void cap(Class<T> capInterface, BlockCapability<C, X> cap, ICapabilityProvider<T, X, C> map) {
        this.tileCaps.add(new TileCapabilityMap<T, C, X>(capInterface, cap, map));
    }

    public <T, C, X> void cap(Class<T> capInterface, ItemCapability<C, X> cap, ICapabilityProvider<ItemStack, X, C> map) {
        this.itemCaps.add(new ItemCapabilityMap<T, C, X>(capInterface, cap, map));
    }

    @MustBeInvokedByOverriders
    public void runRegister() {
        this.onRegisterBlocks();
        this.onRegisterItems();
        this.onRegisterTileEntities();
    }

    protected void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        for (Class<? extends BlockEntity> clazz : this.tileClasses) {
            this.tileCaps.forEach(tcm -> tcm.register(event, tileCls));
        }
        for (Pair pair : this.items) {
            this.itemCaps.forEach(icm -> icm.register(event, (Item)e.getRight()));
        }
    }

    protected void onRegisterBlocks() {
        this.blocks.forEach(e -> Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)Glodium.id(this.id, (String)e.getLeft()), (Object)((Block)e.getRight())));
    }

    protected void onRegisterItems() {
        for (Pair<String, Block> e2 : this.blocks) {
            if (this.itemBlocks.containsKey(e2.getLeft())) {
                Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)Glodium.id(this.id, (String)e2.getLeft()), (Object)((Item)((Function)this.itemBlocks.get(e2.getLeft())).apply((Block)e2.getRight())));
                continue;
            }
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)Glodium.id(this.id, (String)e2.getLeft()), (Object)new BlockItem((Block)e2.getRight(), new Item.Properties()));
        }
        this.items.forEach(e -> Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)Glodium.id(this.id, (String)e.getLeft()), (Object)((Item)e.getRight())));
    }

    protected void onRegisterTileEntities() {
        this.tiles.forEach(e -> Registry.register((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)Glodium.id(this.id, (String)e.getLeft()), (Object)((BlockEntityType)e.getRight())));
    }

    protected record TileCapabilityMap<T, C, X>(Class<T> capInterface, BlockCapability<C, X> cap, ICapabilityProvider<T, X, C> map) {
        public void register(RegisterCapabilitiesEvent event, Class<? extends BlockEntity> tileClazz) {
            if (this.capInterface.isAssignableFrom(tileClazz)) {
                event.registerBlockEntity(this.cap, GlodUtil.getTileType(tileClazz), this.map);
            }
        }
    }

    protected record ItemCapabilityMap<T, C, X>(Class<T> capInterface, ItemCapability<C, X> cap, ICapabilityProvider<ItemStack, X, C> map) {
        public void register(RegisterCapabilitiesEvent event, Item item) {
            if (this.capInterface.isAssignableFrom(item.getClass())) {
                event.registerItem(this.cap, this.map, new ItemLike[]{item});
            }
        }
    }
}

